/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
public abstract class BaseImplicitStatementSupport<D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>>
extends BaseSchemaTreeStatementSupport<D, E> {
    protected BaseImplicitStatementSupport(StatementDefinition publicDefinition) {
        super(publicDefinition);
    }

    @Override
    protected final E createEffective(StmtContext<QName, D, E> ctx, D declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        StatementSource source = ctx.getStatementSource();
        switch (ctx.getStatementSource()) {
            case CONTEXT: {
                return this.createUndeclaredEffective(ctx, substatements);
            }
            case DECLARATION: {
                return this.createDeclaredEffective(ctx, substatements, declared);
            }
        }
        throw new IllegalStateException("Unhandled statement source " + source);
    }

    @Override
    protected final E createEmptyEffective(StmtContext<QName, D, E> ctx, D declared) {
        return this.createEffective(ctx, declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)ImmutableList.of());
    }

    protected abstract @NonNull E createDeclaredEffective(@NonNull StmtContext<QName, D, E> var1, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var2, @NonNull D var3);

    protected abstract @NonNull E createUndeclaredEffective(@NonNull StmtContext<QName, D, E> var1, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var2);
}

