/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseImplicitStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

@Beta
public abstract class BaseOperationContainerStatementSupport<D extends DeclaredStatement<QName>, E extends SchemaTreeEffectiveStatement<D>>
extends BaseImplicitStatementSupport<D, E> {
    private final Function<QNameModule, QName> createArgument;

    protected BaseOperationContainerStatementSupport(StatementDefinition publicDefinition, Function<QNameModule, QName> createArgument) {
        super(publicDefinition);
        this.createArgument = Objects.requireNonNull(createArgument);
    }

    @Override
    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return this.createArgument.apply(StmtContextUtils.getRootModuleQName(ctx));
    }

    @Override
    protected final @NonNull E createDeclaredEffective(StmtContext<QName, D, E> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, D declared) {
        return this.createDeclaredEffective(BaseOperationContainerStatementSupport.historyAndStatusFlags(ctx, substatements), ctx, substatements, declared);
    }

    protected abstract @NonNull E createDeclaredEffective(int var1, @NonNull StmtContext<QName, D, E> var2, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var3, @NonNull D var4);

    @Override
    protected final E createUndeclaredEffective(StmtContext<QName, D, E> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return this.createUndeclaredEffective(BaseOperationContainerStatementSupport.historyAndStatusFlags(ctx, substatements), ctx, substatements);
    }

    protected abstract @NonNull E createUndeclaredEffective(int var1, @NonNull StmtContext<QName, D, E> var2, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var3);
}

