/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

@Beta
public abstract class BaseStatementSupport<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends AbstractStatementSupport<A, D, E> {
    protected BaseStatementSupport(StatementDefinition publicDefinition) {
        super(publicDefinition);
    }

    protected BaseStatementSupport(StatementDefinition publicDefinition, StatementSupport.CopyPolicy copyPolicy) {
        super(publicDefinition, copyPolicy);
    }

    public final D createDeclared(StmtContext<A, D, ?> ctx) {
        ImmutableList substatements = (ImmutableList)ctx.declaredSubstatements().stream().map(StmtContext::buildDeclared).collect(ImmutableList.toImmutableList());
        return substatements.isEmpty() ? this.createEmptyDeclared(ctx) : this.createDeclared(ctx, substatements);
    }

    protected abstract @NonNull D createDeclared(@NonNull StmtContext<A, D, ?> var1, @NonNull ImmutableList<? extends DeclaredStatement<?>> var2);

    protected abstract @NonNull D createEmptyDeclared(@NonNull StmtContext<A, D, ?> var1);

    public E createEffective(StmtContext<A, D, E> ctx) {
        DeclaredStatement declared = ctx.buildDeclared();
        ImmutableList<EffectiveStatement<A, A>> substatements = this.buildEffectiveSubstatements(ctx, this.statementsToBuild(ctx, BaseStatementSupport.declaredSubstatements(ctx)));
        return substatements.isEmpty() ? this.createEmptyEffective(ctx, declared) : this.createEffective(ctx, declared, substatements);
    }

    protected abstract @NonNull E createEffective(@NonNull StmtContext<A, D, E> var1, @NonNull D var2, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> var3);

    protected abstract @NonNull E createEmptyEffective(@NonNull StmtContext<A, D, E> var1, @NonNull D var2);

    protected List<? extends StmtContext<?, ?, ?>> statementsToBuild(StmtContext<A, D, E> ctx, List<? extends StmtContext<?, ?, ?>> substatements) {
        return substatements;
    }

    protected static final <E extends EffectiveStatement<?, ?>> @Nullable E findFirstStatement(ImmutableList<? extends EffectiveStatement<?, ?>> statements, Class<E> type) {
        for (EffectiveStatement stmt : statements) {
            if (!type.isInstance(stmt)) continue;
            return (E)((EffectiveStatement)type.cast(stmt));
        }
        return null;
    }

    protected static final <A, E extends EffectiveStatement<A, ?>> A findFirstArgument(ImmutableList<? extends EffectiveStatement<?, ?>> statements, Class<@NonNull E> type, A defValue) {
        @Nullable E stmt = BaseStatementSupport.findFirstStatement(statements, type);
        return (A)(stmt != null ? stmt.argument() : defValue);
    }

    protected ImmutableList<? extends EffectiveStatement<?, ?>> buildEffectiveSubstatements(StmtContext<A, D, E> ctx, List<? extends StmtContext<?, ?, ?>> substatements) {
        return BaseStatementSupport.defaultBuildEffectiveSubstatements(substatements);
    }

    private static ImmutableList<? extends EffectiveStatement<?, ?>> defaultBuildEffectiveSubstatements(List<? extends StmtContext<?, ?, ?>> substatements) {
        return (ImmutableList)substatements.stream().filter(StmtContext::isSupportedToBuildEffective).map(StmtContext::buildEffective).collect(ImmutableList.toImmutableList());
    }

    private static @NonNull List<StmtContext<?, ?, ?>> declaredSubstatements(StmtContext<?, ?, ?> ctx) {
        ArrayList substatementsInit = new ArrayList();
        HashSet filteredStatements = null;
        for (StmtContext declaredSubstatement : ctx.declaredSubstatements()) {
            if (!declaredSubstatement.isSupportedByFeatures()) continue;
            substatementsInit.add(declaredSubstatement);
            Collection effect = declaredSubstatement.getEffectOfStatement();
            if (effect.isEmpty()) continue;
            if (filteredStatements == null) {
                filteredStatements = new HashSet();
            }
            filteredStatements.addAll(effect);
            substatementsInit.addAll(effect);
        }
        if (filteredStatements != null) {
            for (StmtContext stmt : ctx.effectiveSubstatements()) {
                if (filteredStatements.contains(stmt)) continue;
                substatementsInit.add(stmt);
            }
        } else {
            substatementsInit.addAll(ctx.effectiveSubstatements());
        }
        return substatementsInit;
    }
}

