/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.AddedByUsesAware;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MandatoryAware;
import org.opendaylight.yangtools.yang.model.api.MustConstraintAware;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationNodeContainer;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.WhenConditionAware;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorAppTagEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ErrorMessageEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeDefinitionAware;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathExpression;

@Beta
public final class EffectiveStatementMixins {
    private EffectiveStatementMixins() {
    }

    static <T extends ContainerLike> T findAsContainer(EffectiveStatement<?, ?> stmt, Class<? extends EffectiveStatement<QName, ?>> type, Class<T> target) {
        return (T)((ContainerLike)target.cast(stmt.findFirstEffectiveSubstatement(type).get()));
    }

    static Collection<? extends TypeDefinition<?>> filterTypeDefinitions(Mixin<?, ?> stmt) {
        return Collections2.transform(stmt.filterEffectiveStatements(TypedefEffectiveStatement.class), TypeDefinitionAware::getTypeDefinition);
    }

    public static interface EffectiveStatementWithFlags<A, D extends DeclaredStatement<A>>
    extends Mixin<A, D> {
        public int flags();

        @NonNullByDefault
        public static final class FlagsBuilder
        implements Mutable {
            static final int STATUS_CURRENT = 1;
            static final int STATUS_DEPRECATED = 2;
            static final int STATUS_OBSOLETE = 3;
            static final int MASK_STATUS = 3;
            static final int CONFIGURATION = 4;
            static final int MANDATORY = 8;
            static final int AUGMENTING = 16;
            static final int ADDED_BY_USES = 32;
            private static final int MASK_HISTORY = 48;
            static final int USER_ORDERED = 64;
            static final int PRESENCE = 128;
            private int flags;

            public FlagsBuilder setConfiguration(boolean config) {
                this.flags = config ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
                return this;
            }

            public FlagsBuilder setHistory(CopyHistory history) {
                this.flags = this.flags & 0xFFFFFFCF | (history.isAugmenting() ? 16 : 0) | (history.isAddedByUses() ? 32 : 0);
                return this;
            }

            public FlagsBuilder setMandatory(boolean mandatory) {
                this.flags = mandatory ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
                return this;
            }

            public FlagsBuilder setPresence(boolean presence) {
                this.flags = presence ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
                return this;
            }

            public FlagsBuilder setStatus(Status status) {
                int bits;
                switch (status) {
                    case CURRENT: {
                        bits = 1;
                        break;
                    }
                    case DEPRECATED: {
                        bits = 2;
                        break;
                    }
                    case OBSOLETE: {
                        bits = 3;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled status " + status);
                    }
                }
                this.flags = this.flags & 0xFFFFFFFC | bits;
                return this;
            }

            public FlagsBuilder setUserOrdered(boolean userOrdered) {
                this.flags = userOrdered ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
                return this;
            }

            public int toFlags() {
                return this.flags;
            }
        }
    }

    public static interface OperationDefinitionMixin<D extends DeclaredStatement<QName>>
    extends SchemaNodeMixin<QName, D>,
    OperationDefinition {
        default public @NonNull QName argument() {
            return this.getQName();
        }

        default public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
            return EffectiveStatementMixins.filterTypeDefinitions(this);
        }

        default public Collection<? extends GroupingDefinition> getGroupings() {
            return this.filterEffectiveStatements(GroupingDefinition.class);
        }

        default public InputSchemaNode getInput() {
            return EffectiveStatementMixins.findAsContainer(this, InputEffectiveStatement.class, InputSchemaNode.class);
        }

        default public OutputSchemaNode getOutput() {
            return EffectiveStatementMixins.findAsContainer(this, OutputEffectiveStatement.class, OutputSchemaNode.class);
        }
    }

    public static interface OpaqueDataSchemaNodeMixin<D extends DeclaredStatement<QName>>
    extends DerivableSchemaNode,
    DataSchemaNodeMixin<QName, D>,
    DocumentedNodeMixin.WithStatus<QName, D>,
    MandatoryMixin<QName, D>,
    MustConstraintMixin<QName, D>,
    WhenConditionMixin<QName, D> {
        default public @NonNull QName argument() {
            return this.getQName();
        }
    }

    public static interface OperationContainerMixin<D extends DeclaredStatement<QName>>
    extends ContainerLike,
    DocumentedNodeMixin.WithStatus<QName, D>,
    DataNodeContainerMixin<QName, D>,
    MustConstraintMixin<QName, D>,
    WhenConditionMixin<QName, D>,
    AugmentationTargetMixin<QName, D>,
    SchemaNodeMixin<QName, D>,
    CopyableMixin<QName, D> {
        default public @NonNull QName argument() {
            return this.getQName();
        }

        default public Optional<ActionDefinition> findAction(QName qname) {
            return Optional.empty();
        }

        default public Optional<NotificationDefinition> findNotification(QName qname) {
            return Optional.empty();
        }

        default public Collection<? extends ActionDefinition> getActions() {
            return ImmutableSet.of();
        }

        default public Collection<? extends NotificationDefinition> getNotifications() {
            return ImmutableSet.of();
        }

        default public boolean isConfiguration() {
            return false;
        }

        default public String defaultToString() {
            return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.getPath()).toString();
        }
    }

    public static interface WhenConditionMixin<A, D extends DeclaredStatement<A>>
    extends Mixin<A, D>,
    WhenConditionAware {
        default public Optional<YangXPathExpression.QualifiedBound> getWhenCondition() {
            return this.findFirstEffectiveSubstatementArgument(WhenEffectiveStatement.class);
        }
    }

    public static interface UserOrderedMixin<A, D extends DeclaredStatement<A>>
    extends EffectiveStatementWithFlags<A, D> {
        default public boolean userOrdered() {
            return (this.flags() & 0x40) != 0;
        }
    }

    public static interface UnknownSchemaNodeMixin<A, D extends DeclaredStatement<A>>
    extends SchemaNodeMixin<A, D>,
    CopyableMixin<A, D>,
    UnknownSchemaNode {
        default public String getNodeParameter() {
            return Strings.nullToEmpty((String)this.getDeclared().rawArgument());
        }
    }

    public static interface SchemaNodeMixin<A, D extends DeclaredStatement<A>>
    extends DocumentedNodeMixin.WithStatus<A, D>,
    SchemaNode {
        default public QName getQName() {
            return this.getPath().getLastComponent();
        }
    }

    public static interface PresenceMixin<A, D extends DeclaredStatement<A>>
    extends EffectiveStatementWithFlags<A, D> {
        default public boolean presence() {
            return (this.flags() & 0x80) != 0;
        }
    }

    public static interface MandatoryMixin<A, D extends DeclaredStatement<A>>
    extends EffectiveStatementWithFlags<A, D>,
    MandatoryAware {
        default public boolean isMandatory() {
            return (this.flags() & 8) != 0;
        }
    }

    public static interface ConstraintMetaDefinitionMixin<A, D extends DeclaredStatement<A>>
    extends DocumentedNodeMixin<A, D>,
    ConstraintMetaDefinition {
        default public Optional<String> getErrorAppTag() {
            return this.findFirstEffectiveSubstatementArgument(ErrorAppTagEffectiveStatement.class);
        }

        default public Optional<String> getErrorMessage() {
            return this.findFirstEffectiveSubstatementArgument(ErrorMessageEffectiveStatement.class);
        }
    }

    public static interface DocumentedNodeMixin<A, D extends DeclaredStatement<A>>
    extends Mixin<A, D>,
    DocumentedNode {
        default public Optional<String> getDescription() {
            return this.findFirstEffectiveSubstatementArgument(DescriptionEffectiveStatement.class);
        }

        default public Optional<String> getReference() {
            return this.findFirstEffectiveSubstatementArgument(ReferenceEffectiveStatement.class);
        }

        default public Collection<? extends UnknownSchemaNode> getUnknownSchemaNodes() {
            return this.filterEffectiveStatements(UnknownSchemaNode.class);
        }

        public static interface WithStatus<A, D extends DeclaredStatement<A>>
        extends EffectiveStatementWithFlags<A, D>,
        DocumentedNodeMixin<A, D>,
        DocumentedNode.WithStatus {
            default public Status getStatus() {
                int status = this.flags() & 3;
                switch (status) {
                    case 1: {
                        return Status.CURRENT;
                    }
                    case 2: {
                        return Status.DEPRECATED;
                    }
                    case 3: {
                        return Status.OBSOLETE;
                    }
                }
                throw new IllegalStateException("Illegal status " + status);
            }
        }
    }

    public static interface DataSchemaNodeMixin<A, D extends DeclaredStatement<A>>
    extends DataSchemaNode,
    CopyableMixin<A, D>,
    SchemaNodeMixin<A, D>,
    WhenConditionMixin<A, D> {
        default public boolean isConfiguration() {
            return (this.flags() & 4) != 0;
        }
    }

    public static interface DataNodeContainerMixin<A, D extends DeclaredStatement<A>>
    extends DataNodeContainer,
    Mixin<A, D> {
        default public Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
            return EffectiveStatementMixins.filterTypeDefinitions(this);
        }

        default public Collection<? extends DataSchemaNode> getChildNodes() {
            return this.filterEffectiveStatements(DataSchemaNode.class);
        }

        default public Collection<? extends GroupingDefinition> getGroupings() {
            return this.filterEffectiveStatements(GroupingDefinition.class);
        }

        default public Collection<? extends UsesNode> getUses() {
            return this.filterEffectiveStatements(UsesNode.class);
        }
    }

    public static interface CopyableMixin<A, D extends DeclaredStatement<A>>
    extends AddedByUsesMixin<A, D>,
    CopyableNode {
        default public boolean isAugmenting() {
            return (this.flags() & 0x10) != 0;
        }
    }

    public static interface MustConstraintMixin<A, D extends DeclaredStatement<A>>
    extends Mixin<A, D>,
    MustConstraintAware {
        default public Collection<? extends MustDefinition> getMustConstraints() {
            return this.filterEffectiveStatements(MustDefinition.class);
        }
    }

    public static interface NotificationNodeContainerMixin<A, D extends DeclaredStatement<A>>
    extends Mixin<A, D>,
    NotificationNodeContainer {
        default public Collection<? extends NotificationDefinition> getNotifications() {
            return this.filterEffectiveStatements(NotificationDefinition.class);
        }
    }

    public static interface ActionNodeContainerMixin<A, D extends DeclaredStatement<A>>
    extends Mixin<A, D>,
    ActionNodeContainer {
        default public Collection<? extends ActionDefinition> getActions() {
            return this.filterEffectiveStatements(ActionDefinition.class);
        }
    }

    public static interface AddedByUsesMixin<A, D extends DeclaredStatement<A>>
    extends EffectiveStatementWithFlags<A, D>,
    AddedByUsesAware {
        default public boolean isAddedByUses() {
            return (this.flags() & 0x20) != 0;
        }
    }

    public static interface AugmentationTargetMixin<A, D extends DeclaredStatement<A>>
    extends Mixin<A, D>,
    AugmentationTarget {
        default public Collection<? extends AugmentationSchemaNode> getAvailableAugmentations() {
            return this.filterEffectiveStatements(AugmentationSchemaNode.class);
        }
    }

    private static interface Mixin<A, D extends DeclaredStatement<A>>
    extends EffectiveStatement<A, D> {
        default public <T> @NonNull Collection<? extends T> filterEffectiveStatements(Class<T> type) {
            return Collections2.filter((Collection)this.effectiveSubstatements(), type::isInstance);
        }
    }
}

