/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MaxElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class EffectiveStmtUtils {
    private static final String UNBOUNDED_STR = "unbounded";

    private EffectiveStmtUtils() {
    }

    public static SourceException createNameCollisionSourceException(StmtContext<?, ?, ?> ctx, EffectiveStatement<?, ?> effectiveStatement) {
        return new SourceException(ctx.getStatementSourceReference(), "Error in module '%s': cannot add '%s'. Node name collision: '%s' already declared.", new Object[]{ctx.getRoot().rawStatementArgument(), effectiveStatement.argument(), effectiveStatement.argument()});
    }

    public static Optional<ElementCountConstraint> createElementCountConstraint(EffectiveStatement<?, ?> stmt) {
        return EffectiveStmtUtils.createElementCountConstraint(stmt.findFirstEffectiveSubstatementArgument(MinElementsEffectiveStatement.class).orElse(null), stmt.findFirstEffectiveSubstatementArgument(MaxElementsEffectiveStatement.class).orElse(null));
    }

    public static Optional<ElementCountConstraint> createElementCountConstraint(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStmtUtils.createElementCountConstraint(BaseQNameStatementSupport.findFirstArgument(substatements, MinElementsEffectiveStatement.class, null), BaseQNameStatementSupport.findFirstArgument(substatements, MaxElementsEffectiveStatement.class, null));
    }

    private static Optional<ElementCountConstraint> createElementCountConstraint(@Nullable Integer min, @Nullable String max) {
        Integer m;
        Integer minElements = min != null ? (min > 0 ? min : null) : null;
        Integer maxElements = max != null && !UNBOUNDED_STR.equals(max) ? ((m = Integer.valueOf(max)) < Integer.MAX_VALUE ? m : null) : null;
        return ElementCountConstraint.forNullable((Integer)minElements, maxElements);
    }

    public static boolean hasDefaultValueMarkedWithIfFeature(YangVersion yangVersion, TypeEffectiveStatement<?> typeStmt, Set<String> defaultValues) {
        return !defaultValues.isEmpty() && yangVersion == YangVersion.VERSION_1_1 && EffectiveStmtUtils.isRelevantForIfFeatureCheck(typeStmt) && EffectiveStmtUtils.isAnyDefaultValueMarkedWithIfFeature(typeStmt, new HashSet<String>(defaultValues));
    }

    public static boolean hasDefaultValueMarkedWithIfFeature(YangVersion yangVersion, TypeEffectiveStatement<?> typeStmt, String defaultValue) {
        HashSet<String> defaultValues = new HashSet<String>();
        defaultValues.add(defaultValue);
        return !Strings.isNullOrEmpty((String)defaultValue) && yangVersion == YangVersion.VERSION_1_1 && EffectiveStmtUtils.isRelevantForIfFeatureCheck(typeStmt) && EffectiveStmtUtils.isAnyDefaultValueMarkedWithIfFeature(typeStmt, defaultValues);
    }

    private static boolean isRelevantForIfFeatureCheck(TypeEffectiveStatement<?> typeStmt) {
        TypeDefinition typeDefinition = typeStmt.getTypeDefinition();
        return typeDefinition instanceof EnumTypeDefinition || typeDefinition instanceof BitsTypeDefinition || typeDefinition instanceof UnionTypeDefinition;
    }

    private static boolean isAnyDefaultValueMarkedWithIfFeature(TypeEffectiveStatement<?> typeStmt, Set<String> defaultValues) {
        Iterator iter = typeStmt.effectiveSubstatements().iterator();
        while (iter.hasNext() && !defaultValues.isEmpty()) {
            EffectiveStatement effectiveSubstatement = (EffectiveStatement)iter.next();
            if (YangStmtMapping.BIT.equals((Object)effectiveSubstatement.statementDefinition())) {
                String bitName = (String)effectiveSubstatement.argument();
                if (!defaultValues.remove(bitName) || !EffectiveStmtUtils.containsIfFeature(effectiveSubstatement)) continue;
                return true;
            }
            if (YangStmtMapping.ENUM.equals((Object)effectiveSubstatement.statementDefinition()) && defaultValues.remove(effectiveSubstatement.argument()) && EffectiveStmtUtils.containsIfFeature(effectiveSubstatement)) {
                return true;
            }
            if (!(effectiveSubstatement instanceof TypeEffectiveStatement) || !EffectiveStmtUtils.isAnyDefaultValueMarkedWithIfFeature((TypeEffectiveStatement)effectiveSubstatement, defaultValues)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsIfFeature(EffectiveStatement<?, ?> effectiveStatement) {
        for (EffectiveStatement effectiveSubstatement : effectiveStatement.effectiveSubstatements()) {
            if (!YangStmtMapping.IF_FEATURE.equals((Object)effectiveSubstatement.statementDefinition())) continue;
            return true;
        }
        return false;
    }

    public static void checkUniqueGroupings(StmtContext<?, ?, ?> ctx, Collection<? extends EffectiveStatement<?, ?>> statements) {
        EffectiveStmtUtils.checkUniqueNodes(ctx, statements, GroupingDefinition.class);
    }

    public static void checkUniqueTypedefs(StmtContext<?, ?, ?> ctx, Collection<? extends EffectiveStatement<?, ?>> statements) {
        HashSet<TypeDefinition> typedefs = new HashSet<TypeDefinition>();
        for (EffectiveStatement<?, ?> stmt : statements) {
            if (!(stmt instanceof TypedefEffectiveStatement) || typedefs.add(((TypedefEffectiveStatement)stmt).getTypeDefinition())) continue;
            throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, stmt);
        }
    }

    public static void checkUniqueUses(StmtContext<?, ?, ?> ctx, Collection<? extends EffectiveStatement<?, ?>> statements) {
        EffectiveStmtUtils.checkUniqueNodes(ctx, statements, UsesNode.class);
    }

    private static void checkUniqueNodes(StmtContext<?, ?, ?> ctx, Collection<? extends EffectiveStatement<?, ?>> statements, Class<?> type) {
        HashSet nodes = new HashSet();
        for (EffectiveStatement<?, ?> stmt : statements) {
            if (!type.isInstance(stmt) || nodes.add(stmt)) continue;
            throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, stmt);
        }
    }
}

