/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.action;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.action.ActionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.action.EmptyActionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.action.RegularActionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.input.InputStatementRFC7950Support;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output.OutputStatementRFC7950Support;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

public final class ActionStatementSupport
extends BaseSchemaTreeStatementSupport<ActionStatement, ActionEffectiveStatement> {
    private static final ImmutableSet<StatementDefinition> ILLEGAL_PARENTS = ImmutableSet.of((Object)YangStmtMapping.NOTIFICATION, (Object)YangStmtMapping.RPC, (Object)YangStmtMapping.ACTION);
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ACTION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.INPUT).addOptional((StatementDefinition)YangStmtMapping.OUTPUT).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).build();
    private static final ActionStatementSupport INSTANCE = new ActionStatementSupport();

    private ActionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.ACTION);
    }

    public static ActionStatementSupport getInstance() {
        return INSTANCE;
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, ActionStatement, ActionEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, InputStatement.class) == null) {
            ((StatementContextBase)stmt).appendImplicitSubstatement((StatementSupport)InputStatementRFC7950Support.getInstance(), null);
        }
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, OutputStatement.class) == null) {
            ((StatementContextBase)stmt).appendImplicitSubstatement((StatementSupport)OutputStatementRFC7950Support.getInstance(), null);
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected ActionStatement createDeclared(StmtContext<QName, ActionStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularActionStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected ActionStatement createEmptyDeclared(StmtContext<QName, ActionStatement, ?> ctx) {
        return new EmptyActionStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected ActionEffectiveStatement createEffective(StmtContext<QName, ActionStatement, ActionEffectiveStatement> ctx, ActionStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        QName argument = (QName)ctx.coerceStatementArgument();
        StatementSourceReference ref = ctx.getStatementSourceReference();
        SourceException.throwIf((boolean)StmtContextUtils.hasAncestorOfType(ctx, ILLEGAL_PARENTS), (StatementSourceReference)ref, (String)"Action %s is defined within a notification, rpc or another action", (Object[])new Object[]{argument});
        SourceException.throwIf((!StmtContextUtils.hasAncestorOfTypeWithChildOfType(ctx, (StatementDefinition)YangStmtMapping.LIST, (StatementDefinition)YangStmtMapping.KEY) ? 1 : 0) != 0, (StatementSourceReference)ref, (String)"Action %s is defined within a list that has no key statement", (Object[])new Object[]{argument});
        SourceException.throwIf((boolean)StmtContextUtils.hasParentOfType(ctx, (StatementDefinition)YangStmtMapping.CASE), (StatementSourceReference)ref, (String)"Action %s is defined within a case statement", (Object[])new Object[]{argument});
        SourceException.throwIf((boolean)StmtContextUtils.hasParentOfType(ctx, (StatementDefinition)YangStmtMapping.MODULE), (StatementSourceReference)ref, (String)"Action %s is defined at the top level of a module", (Object[])new Object[]{argument});
        return new ActionEffectiveStatementImpl(declared, (SchemaPath)ctx.getSchemaPath().get(), ActionStatementSupport.historyAndStatusFlags(ctx, substatements), ctx, substatements);
    }

    @Override
    protected ActionEffectiveStatement createEmptyEffective(StmtContext<QName, ActionStatement, ActionEffectiveStatement> ctx, ActionStatement declared) {
        throw new IllegalStateException("Missing implicit input/output statements at " + ctx.getStatementSourceReference());
    }
}

