/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.argument;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ArgumentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ArgumentStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.argument.EmptyArgumentEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.argument.EmptyArgumentStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.argument.RegularArgumentEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.argument.RegularArgumentStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class ArgumentStatementSupport
extends BaseQNameStatementSupport<ArgumentStatement, ArgumentEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ARGUMENT).addOptional((StatementDefinition)YangStmtMapping.YIN_ELEMENT).build();
    private static final ArgumentStatementSupport INSTANCE = new ArgumentStatementSupport();

    private ArgumentStatementSupport() {
        super((StatementDefinition)YangStmtMapping.ARGUMENT);
    }

    public static ArgumentStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected ArgumentStatement createDeclared(StmtContext<QName, ArgumentStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularArgumentStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected ArgumentStatement createEmptyDeclared(StmtContext<QName, ArgumentStatement, ?> ctx) {
        return new EmptyArgumentStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected ArgumentEffectiveStatement createEffective(StmtContext<QName, ArgumentStatement, ArgumentEffectiveStatement> ctx, ArgumentStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularArgumentEffectiveStatement(declared, substatements);
    }

    @Override
    protected ArgumentEffectiveStatement createEmptyEffective(StmtContext<QName, ArgumentStatement, ArgumentEffectiveStatement> ctx, ArgumentStatement declared) {
        return new EmptyArgumentEffectiveStatement(declared);
    }
}

