/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataDefinitionStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.WhenEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.AugmentEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.AugmentImplicitHandlingNamespace;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.EmptyAugmentStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.augment.RegularAugmentStatement;
import org.opendaylight.yangtools.yang.parser.spi.SchemaTreeNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.validation.ValidationBundlesNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAugmentStatementSupport
extends BaseStatementSupport<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAugmentStatementSupport.class);
    private static final Pattern PATH_REL_PATTERN1 = Pattern.compile("\\.\\.?\\s*/(.+)");
    private static final Pattern PATH_REL_PATTERN2 = Pattern.compile("//.*");
    private static final ImmutableSet<YangStmtMapping> NOCOPY_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.USES, (Object)YangStmtMapping.WHEN, (Object)YangStmtMapping.DESCRIPTION, (Object)YangStmtMapping.REFERENCE, (Object)YangStmtMapping.STATUS);
    private static final ImmutableSet<YangStmtMapping> REUSED_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.TYPEDEF);

    AbstractAugmentStatementSupport() {
        super((StatementDefinition)YangStmtMapping.AUGMENT);
    }

    public final SchemaNodeIdentifier parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        SourceException.throwIf((PATH_REL_PATTERN1.matcher(value).matches() || PATH_REL_PATTERN2.matcher(value).matches() ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Augment argument '%s' is not valid, it can be only absolute path; or descendant if used in uses", (Object[])new Object[]{value});
        return ArgumentUtils.nodeIdentifierFromPath(ctx, value);
    }

    public final void onFullDefinitionDeclared(final StmtContext.Mutable<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> augmentNode) {
        if (!augmentNode.isSupportedByFeatures()) {
            augmentNode.setIsSupportedToBuildEffective(false);
        }
        super.onFullDefinitionDeclared(augmentNode);
        if (StmtContextUtils.isInExtensionBody(augmentNode)) {
            return;
        }
        ModelActionBuilder augmentAction = augmentNode.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        augmentAction.requiresCtx(augmentNode, ModelProcessingPhase.EFFECTIVE_MODEL);
        final ModelActionBuilder.Prerequisite target = augmentAction.mutatesEffectiveCtxPath(AbstractAugmentStatementSupport.getSearchRoot(augmentNode), SchemaTreeNamespace.class, (Iterable)((SchemaNodeIdentifier)augmentNode.coerceStatementArgument()).getNodeIdentifiers());
        augmentAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                if (!augmentNode.isSupportedToBuildEffective()) {
                    return;
                }
                StatementContextBase augmentTargetCtx = (StatementContextBase)target.resolve(ctx);
                if (!AbstractAugmentStatementSupport.isSupportedAugmentTarget(augmentTargetCtx) || StmtContextUtils.isInExtensionBody((StmtContext)augmentTargetCtx)) {
                    augmentNode.setIsSupportedToBuildEffective(false);
                    return;
                }
                if (augmentTargetCtx.hasImplicitParentSupport()) {
                    augmentNode.addToNs(AugmentImplicitHandlingNamespace.class, (Object)augmentNode, (Object)augmentTargetCtx);
                }
                StatementContextBase augmentSourceCtx = (StatementContextBase)augmentNode;
                try {
                    AbstractAugmentStatementSupport.copyFromSourceToTarget(augmentSourceCtx, augmentTargetCtx);
                    augmentTargetCtx.addEffectiveSubstatement((StmtContext.Mutable)augmentSourceCtx);
                }
                catch (SourceException e) {
                    LOG.warn("Failed to add augmentation {} defined at {}", new Object[]{augmentTargetCtx.getStatementSourceReference(), augmentSourceCtx.getStatementSourceReference(), e});
                }
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                if (YangStmtMapping.USES == augmentNode.coerceParentContext().getPublicDefinition()) {
                    SchemaNodeIdentifier augmentArg = (SchemaNodeIdentifier)augmentNode.coerceStatementArgument();
                    Optional targetNode = SchemaTreeNamespace.findNode(AbstractAugmentStatementSupport.getSearchRoot(augmentNode), (SchemaNodeIdentifier)augmentArg);
                    if (targetNode.isPresent() && StmtContextUtils.isUnknownStatement((StmtContext)((StmtContext)targetNode.get()))) {
                        augmentNode.setIsSupportedToBuildEffective(false);
                        LOG.warn("Uses-augment to unknown node {}. Augmentation has not been performed. At line: {}", (Object)augmentArg, (Object)augmentNode.getStatementSourceReference());
                        return;
                    }
                }
                throw new InferenceException(augmentNode.getStatementSourceReference(), "Augment target '%s' not found", new Object[]{augmentNode.getStatementArgument()});
            }

            public void prerequisiteUnavailable(ModelActionBuilder.Prerequisite<?> unavail) {
                if (target.equals(unavail)) {
                    augmentNode.setIsSupportedToBuildEffective(false);
                } else {
                    this.prerequisiteFailed(List.of(unavail));
                }
            }
        });
    }

    @Override
    protected final AugmentStatement createDeclared(StmtContext<SchemaNodeIdentifier, AugmentStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularAugmentStatement(ctx.coerceRawStatementArgument(), (SchemaNodeIdentifier)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final AugmentStatement createEmptyDeclared(StmtContext<SchemaNodeIdentifier, AugmentStatement, ?> ctx) {
        return new EmptyAugmentStatement(ctx.coerceRawStatementArgument(), (SchemaNodeIdentifier)ctx.coerceStatementArgument());
    }

    @Override
    protected final List<? extends StmtContext<?, ?, ?>> statementsToBuild(StmtContext<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> ctx, List<? extends StmtContext<?, ?, ?>> substatements) {
        StatementContextBase implicitDef = (StatementContextBase)ctx.getFromNamespace(AugmentImplicitHandlingNamespace.class, ctx);
        return implicitDef == null ? substatements : Lists.transform(substatements, subCtx -> {
            Verify.verify((boolean)(subCtx instanceof StatementContextBase));
            return implicitDef.wrapWithImplicit((StatementContextBase)subCtx);
        });
    }

    @Override
    protected final AugmentEffectiveStatement createEffective(StmtContext<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> ctx, AugmentStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        int flags = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus(AbstractAugmentStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).toFlags();
        return new AugmentEffectiveStatementImpl(declared, (SchemaNodeIdentifier)ctx.coerceStatementArgument(), flags, StmtContextUtils.getRootModuleQName(ctx), substatements, ctx.getStatementSourceReference(), ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null));
    }

    @Override
    protected final AugmentEffectiveStatement createEmptyEffective(StmtContext<SchemaNodeIdentifier, AugmentStatement, AugmentEffectiveStatement> ctx, AugmentStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    private static StmtContext<?, ?, ?> getSearchRoot(StmtContext<?, ?, ?> augmentContext) {
        StmtContext parent = augmentContext.coerceParentContext();
        if (YangStmtMapping.USES == parent.getPublicDefinition()) {
            return parent.getParentContext();
        }
        return parent;
    }

    static void copyFromSourceToTarget(StatementContextBase<?, ?, ?> sourceCtx, StatementContextBase<?, ?, ?> targetCtx) {
        CopyType typeOfCopy = sourceCtx.coerceParentContext().producesDeclared(UsesStatement.class) ? CopyType.ADDED_BY_USES_AUGMENTATION : CopyType.ADDED_BY_AUGMENTATION;
        boolean skipCheckOfMandatoryNodes = YangVersion.VERSION_1_1.equals((Object)sourceCtx.getRootVersion()) && AbstractAugmentStatementSupport.isConditionalAugmentStmt(sourceCtx);
        boolean unsupported = !sourceCtx.isSupportedByFeatures();
        Collection declared = sourceCtx.mutableDeclaredSubstatements();
        Collection effective = sourceCtx.mutableEffectiveSubstatements();
        ArrayList buffer = new ArrayList(declared.size() + effective.size());
        for (StmtContext.Mutable originalStmtCtx : declared) {
            AbstractAugmentStatementSupport.copyStatement(originalStmtCtx, targetCtx, typeOfCopy, buffer, skipCheckOfMandatoryNodes, unsupported || !originalStmtCtx.isSupportedByFeatures());
        }
        for (StmtContext.Mutable originalStmtCtx : effective) {
            AbstractAugmentStatementSupport.copyStatement(originalStmtCtx, targetCtx, typeOfCopy, buffer, skipCheckOfMandatoryNodes, unsupported);
        }
        targetCtx.addEffectiveSubstatements(buffer);
    }

    private static boolean isConditionalAugmentStmt(StmtContext<?, ?, ?> ctx) {
        return ctx.getPublicDefinition() == YangStmtMapping.AUGMENT && AbstractAugmentStatementSupport.hasWhenSubstatement(ctx);
    }

    private static boolean hasWhenSubstatement(StmtContext<?, ?, ?> ctx) {
        return ctx.hasSubstatement(WhenEffectiveStatement.class);
    }

    private static void copyStatement(StmtContext.Mutable<?, ?, ?> original, StatementContextBase<?, ?, ?> target, CopyType typeOfCopy, Collection<StmtContext.Mutable<?, ?, ?>> buffer, boolean skipCheckOfMandatoryNodes, boolean unsupported) {
        if (AbstractAugmentStatementSupport.needToCopyByAugment(original)) {
            AbstractAugmentStatementSupport.validateNodeCanBeCopiedByAugment(original, target, typeOfCopy, skipCheckOfMandatoryNodes);
            StmtContext.Mutable copy = target.childCopyOf(original, typeOfCopy);
            if (unsupported) {
                copy.setIsSupportedToBuildEffective(false);
            }
            buffer.add(copy);
        } else if (AbstractAugmentStatementSupport.isReusedByAugment(original) && !unsupported) {
            buffer.add(original);
        }
    }

    private static void validateNodeCanBeCopiedByAugment(StmtContext<?, ?, ?> sourceCtx, StatementContextBase<?, ?, ?> targetCtx, CopyType typeOfCopy, boolean skipCheckOfMandatoryNodes) {
        if (!skipCheckOfMandatoryNodes && typeOfCopy == CopyType.ADDED_BY_AUGMENTATION && AbstractAugmentStatementSupport.requireCheckOfMandatoryNodes(sourceCtx, targetCtx)) {
            AbstractAugmentStatementSupport.checkForMandatoryNodes(sourceCtx);
        }
        if (sourceCtx.producesDeclared(DataDefinitionStatement.class)) {
            for (StmtContext subStatement : targetCtx.allSubstatements()) {
                if (!subStatement.producesDeclared(DataDefinitionStatement.class)) continue;
                InferenceException.throwIf((boolean)Objects.equals(sourceCtx.getStatementArgument(), subStatement.getStatementArgument()), (StatementSourceReference)sourceCtx.getStatementSourceReference(), (String)"An augment cannot add node named '%s' because this name is already used in target", (Object[])new Object[]{sourceCtx.rawStatementArgument()});
            }
        }
    }

    private static void checkForMandatoryNodes(StmtContext<?, ?, ?> sourceCtx) {
        if (StmtContextUtils.isNonPresenceContainer(sourceCtx)) {
            sourceCtx.allSubstatementsStream().forEach(AbstractAugmentStatementSupport::checkForMandatoryNodes);
        }
        InferenceException.throwIf((boolean)StmtContextUtils.isMandatoryNode(sourceCtx), (StatementSourceReference)sourceCtx.getStatementSourceReference(), (String)"An augment cannot add node '%s' because it is mandatory and in module different than target", (Object[])new Object[]{sourceCtx.rawStatementArgument()});
    }

    private static boolean requireCheckOfMandatoryNodes(StmtContext<?, ?, ?> sourceCtx, StmtContext.Mutable<?, ?, ?> targetCtx) {
        Object arg = sourceCtx.getStatementArgument();
        if (!(arg instanceof QName)) {
            return false;
        }
        QName sourceStmtQName = (QName)arg;
        StmtContext.Mutable root = targetCtx.getRoot();
        do {
            Optional optPrevCopy;
            Object targetArg = targetCtx.getStatementArgument();
            Verify.verify((boolean)(targetArg instanceof QName), (String)"Argument of augment target statement must be QName, not %s", (Object)targetArg);
            QName targetStmtQName = (QName)targetArg;
            if (!targetStmtQName.getModule().equals((Object)sourceStmtQName.getModule())) {
                return true;
            }
            if (StmtContextUtils.isPresenceContainer(targetCtx) || StmtContextUtils.isNotMandatoryNodeOfType(targetCtx, (StatementDefinition)YangStmtMapping.CHOICE) || StmtContextUtils.isNotMandatoryNodeOfType(targetCtx, (StatementDefinition)YangStmtMapping.LIST)) {
                return false;
            }
            if (targetCtx.getCopyHistory().getLastOperation() != CopyType.ADDED_BY_AUGMENTATION || !(optPrevCopy = targetCtx.getPreviousCopyCtx()).isPresent()) continue;
            StmtContext original = (StmtContext)optPrevCopy.get();
            Object origArg = original.coerceStatementArgument();
            Verify.verify((boolean)(origArg instanceof QName), (String)"Unexpected statement argument %s", (Object)origArg);
            if (!sourceStmtQName.getModule().equals((Object)((QName)origArg).getModule()) || !AbstractAugmentStatementSupport.hasWhenSubstatement(AbstractAugmentStatementSupport.getParentAugmentation(original))) continue;
            return false;
        } while ((targetCtx = targetCtx.getParentContext()) != root);
        return false;
    }

    private static StmtContext<?, ?, ?> getParentAugmentation(StmtContext<?, ?, ?> child) {
        StmtContext parent = (StmtContext)Verify.verifyNotNull((Object)child.getParentContext(), (String)"Child %s has not parent", (Object[])new Object[]{child});
        while (parent.getPublicDefinition() != YangStmtMapping.AUGMENT) {
            parent = (StmtContext)Verify.verifyNotNull((Object)parent.getParentContext(), (String)"Failed to find augmentation parent of %s", (Object[])new Object[]{child});
        }
        return parent;
    }

    private static boolean needToCopyByAugment(StmtContext<?, ?, ?> stmtContext) {
        return !NOCOPY_DEF_SET.contains((Object)stmtContext.getPublicDefinition());
    }

    private static boolean isReusedByAugment(StmtContext<?, ?, ?> stmtContext) {
        return REUSED_DEF_SET.contains((Object)stmtContext.getPublicDefinition());
    }

    static boolean isSupportedAugmentTarget(StmtContext<?, ?, ?> substatementCtx) {
        Collection allowedAugmentTargets = (Collection)substatementCtx.getFromNamespace(ValidationBundlesNamespace.class, (Object)ValidationBundlesNamespace.ValidationBundleType.SUPPORTED_AUGMENT_TARGETS);
        return allowedAugmentTargets == null || allowedAugmentTargets.isEmpty() || allowedAugmentTargets.contains(substatementCtx.getPublicDefinition());
    }
}

