/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.case_;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseImplicitStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.case_.DeclaredCaseEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.case_.EmptyCaseStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.case_.EmptyUndeclaredCaseStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.case_.RegularCaseStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.case_.RegularUndeclaredCaseStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.case_.UndeclaredCaseEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

abstract class AbstractCaseStatementSupport
extends BaseImplicitStatementSupport<CaseStatement, CaseEffectiveStatement> {
    AbstractCaseStatementSupport() {
        super((StatementDefinition)YangStmtMapping.CASE);
    }

    @Override
    protected final CaseStatement createDeclared(StmtContext<QName, CaseStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        StatementSource source = ctx.getStatementSource();
        switch (ctx.getStatementSource()) {
            case CONTEXT: {
                return new RegularUndeclaredCaseStatement((QName)ctx.coerceStatementArgument(), substatements);
            }
            case DECLARATION: {
                return new RegularCaseStatement((QName)ctx.coerceStatementArgument(), substatements);
            }
        }
        throw new IllegalStateException("Unhandled statement source " + source);
    }

    @Override
    protected final CaseStatement createEmptyDeclared(StmtContext<QName, CaseStatement, ?> ctx) {
        StatementSource source = ctx.getStatementSource();
        switch (ctx.getStatementSource()) {
            case CONTEXT: {
                return new EmptyUndeclaredCaseStatement((QName)ctx.coerceStatementArgument());
            }
            case DECLARATION: {
                return new EmptyCaseStatement((QName)ctx.coerceStatementArgument());
            }
        }
        throw new IllegalStateException("Unhandled statement source " + source);
    }

    @Override
    protected final CaseEffectiveStatement createDeclaredEffective(StmtContext<QName, CaseStatement, CaseEffectiveStatement> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, CaseStatement declared) {
        return new DeclaredCaseEffectiveStatement(declared, ctx, substatements, AbstractCaseStatementSupport.computeFlags(ctx, substatements), AbstractCaseStatementSupport.findOriginal(ctx));
    }

    @Override
    protected final CaseEffectiveStatement createUndeclaredEffective(StmtContext<QName, CaseStatement, CaseEffectiveStatement> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new UndeclaredCaseEffectiveStatement(ctx, substatements, AbstractCaseStatementSupport.computeFlags(ctx, substatements), AbstractCaseStatementSupport.findOriginal(ctx));
    }

    private static @Nullable CaseSchemaNode findOriginal(StmtContext<?, ?, ?> ctx) {
        return ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
    }

    private static int computeFlags(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(AbstractCaseStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).setConfiguration(ctx.isConfiguration() && ctx.allSubstatementsStream().anyMatch(StmtContext::isConfiguration)).toFlags();
    }
}

