/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.choice;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

final class ChoiceEffectiveStatementImpl
extends AbstractDeclaredEffectiveStatement.DefaultWithSchemaTree.WithSubstatements<QName, ChoiceStatement, ChoiceEffectiveStatement>
implements ChoiceEffectiveStatement,
ChoiceSchemaNode,
DerivableSchemaNode,
EffectiveStatementMixins.DataSchemaNodeMixin<QName, ChoiceStatement>,
EffectiveStatementMixins.AugmentationTargetMixin<QName, ChoiceStatement>,
EffectiveStatementMixins.MandatoryMixin<QName, ChoiceStatement> {
    private final CaseSchemaNode defaultCase;
    private final ChoiceSchemaNode original;
    private final @NonNull SchemaPath path;
    private final int flags;

    ChoiceEffectiveStatementImpl(ChoiceStatement declared, StmtContext<QName, ChoiceStatement, ChoiceEffectiveStatement> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, int flags, @Nullable CaseSchemaNode defaultCase, @Nullable ChoiceSchemaNode original) {
        super(declared, ctx, substatements);
        this.flags = flags;
        this.path = (SchemaPath)ctx.getSchemaPath().get();
        this.defaultCase = defaultCase;
        this.original = original;
    }

    public @NonNull QName argument() {
        return this.getQName();
    }

    @Deprecated
    public SchemaPath getPath() {
        return this.path;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    public Optional<ChoiceSchemaNode> getOriginal() {
        return Optional.ofNullable(this.original);
    }

    public Optional<? extends CaseSchemaNode> findCase(QName qname) {
        SchemaTreeEffectiveStatement<?> child = this.schemaTreeNamespace().get(Objects.requireNonNull(qname));
        return child instanceof CaseSchemaNode ? Optional.of((CaseSchemaNode)child) : Optional.empty();
    }

    public Collection<? extends @NonNull CaseSchemaNode> getCases() {
        return this.filterEffectiveStatements(CaseSchemaNode.class);
    }

    public Optional<CaseSchemaNode> getDefaultCase() {
        return Optional.ofNullable(this.defaultCase);
    }

    public ChoiceEffectiveStatement asEffectiveStatement() {
        return this;
    }

    public String toString() {
        return ChoiceEffectiveStatementImpl.class.getSimpleName() + "[qname=" + this.getQName() + "]";
    }
}

