/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.container;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.container.ContainerEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.container.EmptyContainerStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.container.RegularContainerStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

abstract class AbstractContainerStatementSupport
extends BaseSchemaTreeStatementSupport<ContainerStatement, ContainerEffectiveStatement> {
    AbstractContainerStatementSupport() {
        super((StatementDefinition)YangStmtMapping.CONTAINER);
    }

    @Override
    protected final ContainerStatement createDeclared(StmtContext<QName, ContainerStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularContainerStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final ContainerStatement createEmptyDeclared(StmtContext<QName, ContainerStatement, ?> ctx) {
        return new EmptyContainerStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected final ContainerEffectiveStatement createEffective(StmtContext<QName, ContainerStatement, ContainerEffectiveStatement> ctx, ContainerStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        SchemaPath path = (SchemaPath)ctx.getSchemaPath().get();
        ContainerSchemaNode original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        int flags = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory(ctx.getCopyHistory()).setStatus(AbstractContainerStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).setConfiguration(ctx.isConfiguration()).setPresence(AbstractContainerStatementSupport.findFirstStatement(substatements, PresenceEffectiveStatement.class) != null).toFlags();
        return new ContainerEffectiveStatementImpl(declared, path, flags, ctx, substatements, original);
    }

    @Override
    protected final ContainerEffectiveStatement createEmptyEffective(StmtContext<QName, ContainerStatement, ContainerEffectiveStatement> ctx, ContainerStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }
}

