/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviation.DeviationEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.deviation.DeviationStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;

public final class DeviationStatementSupport
extends BaseStatementSupport<SchemaNodeIdentifier.Absolute, DeviationStatement, DeviationEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.DEVIATION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.DEVIATE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();
    private static final DeviationStatementSupport INSTANCE = new DeviationStatementSupport();

    private DeviationStatementSupport() {
        super((StatementDefinition)YangStmtMapping.DEVIATION);
    }

    public static DeviationStatementSupport getInstance() {
        return INSTANCE;
    }

    public SchemaNodeIdentifier.Absolute parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return ArgumentUtils.parseAbsoluteSchemaNodeIdentifier(ctx, value);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<SchemaNodeIdentifier.Absolute, DeviationStatement, DeviationEffectiveStatement> ctx) {
        QNameModule targetModule;
        QNameModule currentModule = (QNameModule)ctx.getFromNamespace(ModuleCtxToModuleQName.class, (Object)ctx.getRoot());
        if (currentModule.equals((Object)(targetModule = ((QName)Iterables.getLast((Iterable)((SchemaNodeIdentifier.Absolute)ctx.coerceStatementArgument()).getNodeIdentifiers())).getModule()))) {
            throw new InferenceException(ctx.getStatementSourceReference(), "Deviation must not target the same module as the one it is defined in: %s", new Object[]{currentModule});
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected DeviationStatement createDeclared(StmtContext<SchemaNodeIdentifier.Absolute, DeviationStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new DeviationStatementImpl(ctx, substatements);
    }

    @Override
    protected DeviationStatement createEmptyDeclared(StmtContext<SchemaNodeIdentifier.Absolute, DeviationStatement, ?> ctx) {
        return new DeviationStatementImpl(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    @Override
    protected DeviationEffectiveStatement createEffective(StmtContext<SchemaNodeIdentifier.Absolute, DeviationStatement, DeviationEffectiveStatement> ctx, DeviationStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new DeviationEffectiveStatementImpl(declared, substatements);
    }

    @Override
    protected DeviationEffectiveStatement createEmptyEffective(StmtContext<SchemaNodeIdentifier.Absolute, DeviationStatement, DeviationEffectiveStatement> ctx, DeviationStatement declared) {
        return new DeviationEffectiveStatementImpl(declared, ImmutableList.of());
    }
}

