/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnqualifiedQName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UnrecognizedEffectiveStatementImpl
extends UnknownEffectiveStatementBase<String, UnrecognizedStatement>
implements UnrecognizedEffectiveStatement {
    private static final Logger LOG = LoggerFactory.getLogger(UnrecognizedEffectiveStatementImpl.class);
    private final QName maybeQNameArgument;
    private final @NonNull SchemaPath path;

    UnrecognizedEffectiveStatementImpl(@NonNull UnrecognizedStatement declared, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> substatements, StmtContext<String, UnrecognizedStatement, ?> ctx) {
        super((String)ctx.getStatementArgument(), declared, substatements, ctx);
        SchemaPath maybePath;
        QName qname;
        UnknownSchemaNode original = ctx.getOriginalCtx().map(StmtContext::buildEffective).orElse(null);
        this.maybeQNameArgument = original == null ? ((qname = UnrecognizedEffectiveStatementImpl.qnameFromArgument(ctx)) != null ? qname : this.getNodeType()) : original.getQName();
        try {
            maybePath = ctx.coerceParentContext().getSchemaPath().map(parentPath -> parentPath.createChild(this.maybeQNameArgument)).orElse(null);
        }
        catch (IllegalArgumentException | SourceException e) {
            LOG.debug("Cannot construct path for {}, attempting to recover", ctx, (Object)e);
            maybePath = null;
        }
        this.path = maybePath;
    }

    public QName getQName() {
        return this.maybeQNameArgument;
    }

    @Deprecated
    public SchemaPath getPath() {
        return this.path;
    }

    public StatementDefinition statementDefinition() {
        return ((UnrecognizedStatement)this.getDeclared()).statementDefinition();
    }

    private static QName qnameFromArgument(StmtContext<String, UnrecognizedStatement, ?> stmt) {
        String value = (String)stmt.getStatementArgument();
        if (value == null || value.isEmpty()) {
            return stmt.getPublicDefinition().getStatementName();
        }
        int colon = value.indexOf(58);
        if (colon == -1) {
            UnqualifiedQName qname = UnqualifiedQName.tryCreate((String)value);
            return qname == null ? null : qname.bindTo(StmtContextUtils.getRootModuleQName(stmt)).intern();
        }
        QNameModule qnameModule = StmtContextUtils.getModuleQNameByPrefix(stmt, (String)value.substring(0, colon));
        if (qnameModule == null) {
            return null;
        }
        int next = value.indexOf(58, colon + 1);
        String localName = next == -1 ? value.substring(colon + 1) : value.substring(colon + 1, next);
        UnqualifiedQName qname = UnqualifiedQName.tryCreate((String)localName);
        return qname == null ? null : qname.bindTo(qnameModule).intern();
    }
}

