/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnrecognizedStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ModelDefinedStatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.ModelDefinedStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.UnrecognizedEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.extension.UnrecognizedStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

final class UnrecognizedStatementSupport
extends BaseStatementSupport<String, UnrecognizedStatement, UnrecognizedEffectiveStatement> {
    UnrecognizedStatementSupport(StatementDefinition publicDefinition) {
        super(publicDefinition);
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public Optional<StatementSupport<?, ?, ?>> getUnknownStatementDefinitionOf(StatementDefinition yangStmtDef) {
        ModelDefinedStatementDefinition def;
        QName baseQName = this.getStatementName();
        QName statementName = QName.create((QName)baseQName, (String)yangStmtDef.getStatementName().getLocalName());
        Optional optArgDef = yangStmtDef.getArgumentDefinition();
        if (optArgDef.isPresent()) {
            ArgumentDefinition argDef = (ArgumentDefinition)optArgDef.get();
            def = new ModelDefinedStatementDefinition(statementName, argDef.getArgumentName(), argDef.isYinElement());
        } else {
            def = new ModelDefinedStatementDefinition(statementName);
        }
        return Optional.of(new ModelDefinedStatementSupport(def));
    }

    protected SubstatementValidator getSubstatementValidator() {
        return null;
    }

    @Override
    protected UnrecognizedStatement createDeclared(StmtContext<String, UnrecognizedStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new UnrecognizedStatementImpl(ctx, substatements);
    }

    @Override
    protected UnrecognizedStatement createEmptyDeclared(StmtContext<String, UnrecognizedStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    @Override
    protected UnrecognizedEffectiveStatement createEffective(StmtContext<String, UnrecognizedStatement, UnrecognizedEffectiveStatement> ctx, UnrecognizedStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new UnrecognizedEffectiveStatementImpl(declared, substatements, ctx);
    }

    @Override
    protected UnrecognizedEffectiveStatement createEmptyEffective(StmtContext<String, UnrecognizedStatement, UnrecognizedEffectiveStatement> ctx, UnrecognizedStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }
}

