/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.feature;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.feature.EmptyFeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.feature.EmptyFeatureStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.feature.RegularFeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.feature.RegularFeatureStatement;
import org.opendaylight.yangtools.yang.parser.spi.FeatureNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class FeatureStatementSupport
extends BaseQNameStatementSupport<FeatureStatement, FeatureEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.FEATURE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();
    private static final FeatureStatementSupport INSTANCE = new FeatureStatementSupport();
    private static final int EMPTY_EFFECTIVE_FLAGS = new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus(Status.CURRENT).toFlags();

    private FeatureStatementSupport() {
        super((StatementDefinition)YangStmtMapping.FEATURE);
    }

    public static FeatureStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, FeatureStatement, FeatureEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        stmt.addContext(FeatureNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected FeatureStatement createDeclared(StmtContext<QName, FeatureStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularFeatureStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected FeatureStatement createEmptyDeclared(@NonNull StmtContext<QName, FeatureStatement, ?> ctx) {
        return new EmptyFeatureStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected FeatureEffectiveStatement createEffective(StmtContext<QName, FeatureStatement, FeatureEffectiveStatement> ctx, FeatureStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularFeatureEffectiveStatement(declared, (SchemaPath)ctx.getSchemaPath().get(), FeatureStatementSupport.computeFlags(substatements), substatements);
    }

    @Override
    protected FeatureEffectiveStatement createEmptyEffective(StmtContext<QName, FeatureStatement, FeatureEffectiveStatement> ctx, FeatureStatement declared) {
        return new EmptyFeatureEffectiveStatement(declared, (SchemaPath)ctx.getSchemaPath().get(), EMPTY_EFFECTIVE_FLAGS);
    }

    private static int computeFlags(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus(FeatureStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).toFlags();
    }
}

