/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.fraction_digits;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.fraction_digits.EmptyFractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.fraction_digits.EmptyFractionDigitsStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.fraction_digits.RegularFractionDigitsEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.fraction_digits.RegularFractionDigitsStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class FractionDigitsStatementSupport
extends BaseStatementSupport<Integer, FractionDigitsStatement, FractionDigitsEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.FRACTION_DIGITS).build();
    private static final FractionDigitsStatementSupport INSTANCE = new FractionDigitsStatementSupport();
    private static final ImmutableMap<Integer, EmptyFractionDigitsStatement> EMPTY_DECLS;
    private static final ImmutableMap<EmptyFractionDigitsStatement, EmptyFractionDigitsEffectiveStatement> EMPTY_EFF;

    private FractionDigitsStatementSupport() {
        super((StatementDefinition)YangStmtMapping.FRACTION_DIGITS, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public static FractionDigitsStatementSupport getInstance() {
        return INSTANCE;
    }

    public Integer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        int fractionDigits;
        try {
            fractionDigits = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "%s is not valid fraction-digits integer argument", new Object[]{value});
        }
        if (fractionDigits < 1 || fractionDigits > 18) {
            throw new SourceException("fraction-digits argument should be integer within [1..18]", ctx.getStatementSourceReference());
        }
        return fractionDigits;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected FractionDigitsStatement createDeclared(StmtContext<Integer, FractionDigitsStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularFractionDigitsStatement((Integer)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected FractionDigitsStatement createEmptyDeclared(StmtContext<Integer, FractionDigitsStatement, ?> ctx) {
        Integer argument = (Integer)ctx.coerceStatementArgument();
        return (FractionDigitsStatement)Verify.verifyNotNull((Object)((EmptyFractionDigitsStatement)EMPTY_DECLS.get((Object)argument)), (String)"No declared instance for %s", (Object[])new Object[]{argument});
    }

    @Override
    protected FractionDigitsEffectiveStatement createEffective(StmtContext<Integer, FractionDigitsStatement, FractionDigitsEffectiveStatement> ctx, FractionDigitsStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularFractionDigitsEffectiveStatement(declared, substatements);
    }

    @Override
    protected FractionDigitsEffectiveStatement createEmptyEffective(StmtContext<Integer, FractionDigitsStatement, FractionDigitsEffectiveStatement> ctx, FractionDigitsStatement declared) {
        EmptyFractionDigitsEffectiveStatement shared = (EmptyFractionDigitsEffectiveStatement)EMPTY_EFF.get((Object)declared);
        return shared != null ? shared : new EmptyFractionDigitsEffectiveStatement(declared);
    }

    static {
        ImmutableMap.Builder declBuilder = ImmutableMap.builder();
        ImmutableMap.Builder effBuilder = ImmutableMap.builder();
        for (int i = 1; i <= 18; ++i) {
            Integer argument = i;
            EmptyFractionDigitsStatement decl = new EmptyFractionDigitsStatement(argument);
            declBuilder.put((Object)argument, (Object)decl);
            effBuilder.put((Object)decl, (Object)new EmptyFractionDigitsEffectiveStatement(decl));
        }
        EMPTY_DECLS = declBuilder.build();
        EMPTY_EFF = effBuilder.build();
    }
}

