/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.import_;

import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionDateStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.ModuleQNameToPrefix;
import org.opendaylight.yangtools.yang.parser.rfc7950.namespace.URIStringToImportPrefix;
import org.opendaylight.yangtools.yang.parser.spi.ModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportedModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToSourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class RevisionImport {
    private RevisionImport() {
    }

    static void onLinkageDeclared(final StmtContext.Mutable<String, ImportStatement, ImportEffectiveStatement> stmt) {
        ModelActionBuilder importAction = stmt.newInferenceAction(ModelProcessingPhase.SOURCE_LINKAGE);
        final String moduleName = (String)stmt.coerceStatementArgument();
        Revision revision = (Revision)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), RevisionDateStatement.class);
        final ModelActionBuilder.Prerequisite imported = revision == null ? importAction.requiresCtx(stmt, ModuleNamespace.class, NamespaceKeyCriterion.latestRevisionModule((String)moduleName), ModelProcessingPhase.SOURCE_LINKAGE) : importAction.requiresCtx(stmt, ModuleNamespace.class, (Object)RevisionSourceIdentifier.create((String)moduleName, Optional.of(revision)), ModelProcessingPhase.SOURCE_LINKAGE);
        final ModelActionBuilder.Prerequisite linkageTarget = importAction.mutatesCtx(stmt.getRoot(), ModelProcessingPhase.SOURCE_LINKAGE);
        importAction.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
                StmtContext importedModule = (StmtContext)imported.resolve(ctx);
                QNameModule mod = (QNameModule)InferenceException.throwIfNull((Object)((QNameModule)stmt.getFromNamespace(ModuleCtxToModuleQName.class, (Object)importedModule)), (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Failed to find module of %s", (Object[])new Object[]{importedModule});
                ((StmtContext.Mutable)linkageTarget.resolve(ctx)).addToNs(ImportedModuleContext.class, (Object)((SourceIdentifier)stmt.getFromNamespace(ModuleCtxToSourceIdentifier.class, (Object)importedModule)), (Object)importedModule);
                String impPrefix = (String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class);
                URI modNs = (URI)StmtContextUtils.firstAttributeOf((Iterable)importedModule.declaredSubstatements(), NamespaceStatement.class);
                stmt.addToNs(ImportPrefixToModuleCtx.class, (Object)impPrefix, (Object)importedModule);
                stmt.addToNs(ModuleQNameToPrefix.class, (Object)mod, (Object)impPrefix);
                stmt.addToNs(URIStringToImportPrefix.class, (Object)modNs.toString(), (Object)impPrefix);
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                if (failed.contains(imported)) {
                    throw new InferenceException(stmt.getStatementSourceReference(), "Imported module [%s] was not found.", new Object[]{moduleName});
                }
            }
        });
    }

    static SourceIdentifier getImportedSourceIdentifier(StmtContext<String, ImportStatement, ?> stmt) {
        StmtContext revision = StmtContextUtils.findFirstDeclaredSubstatement(stmt, RevisionDateStatement.class);
        return revision == null ? RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument())) : RevisionSourceIdentifier.create((String)((String)stmt.getStatementArgument()), (Revision)((Revision)revision.getStatementArgument()));
    }
}

