/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.list;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UniqueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.compat.ActionNodeContainerCompat;
import org.opendaylight.yangtools.yang.model.api.stmt.compat.NotificationNodeContainerCompat;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

abstract class AbstractListEffectiveStatement
extends AbstractDeclaredEffectiveStatement.DefaultWithDataTree<QName, ListStatement, ListEffectiveStatement>
implements ListEffectiveStatement,
ListSchemaNode,
DerivableSchemaNode,
ActionNodeContainerCompat<QName, ListStatement, ListEffectiveStatement>,
NotificationNodeContainerCompat<QName, ListStatement, ListEffectiveStatement>,
EffectiveStatementMixins.DataSchemaNodeMixin<QName, ListStatement>,
EffectiveStatementMixins.UserOrderedMixin<QName, ListStatement>,
EffectiveStatementMixins.DataNodeContainerMixin<QName, ListStatement>,
EffectiveStatementMixins.WhenConditionMixin<QName, ListStatement>,
EffectiveStatementMixins.AugmentationTargetMixin<QName, ListStatement>,
EffectiveStatementMixins.NotificationNodeContainerMixin<QName, ListStatement>,
EffectiveStatementMixins.ActionNodeContainerMixin<QName, ListStatement>,
EffectiveStatementMixins.MustConstraintMixin<QName, ListStatement> {
    private final int flags;
    private final @NonNull Object substatements;
    private final @NonNull SchemaPath path;
    private final @NonNull Object keyDefinition;

    AbstractListEffectiveStatement(ListStatement declared, SchemaPath path, int flags, StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, ImmutableList<QName> keyDefinition) {
        super(declared, ctx, substatements);
        EffectiveStmtUtils.checkUniqueGroupings(ctx, substatements);
        EffectiveStmtUtils.checkUniqueTypedefs(ctx, substatements);
        EffectiveStmtUtils.checkUniqueUses(ctx, substatements);
        this.substatements = AbstractListEffectiveStatement.maskList(substatements);
        this.path = Objects.requireNonNull(path);
        this.keyDefinition = AbstractListEffectiveStatement.maskList(keyDefinition);
        this.flags = flags;
    }

    public final ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return AbstractListEffectiveStatement.unmaskList(this.substatements);
    }

    @Override
    public final int flags() {
        return this.flags;
    }

    public final @NonNull QName argument() {
        return this.getQName();
    }

    @Deprecated
    public final SchemaPath getPath() {
        return this.path;
    }

    public final boolean isUserOrdered() {
        return this.userOrdered();
    }

    public final List<QName> getKeyDefinition() {
        return AbstractListEffectiveStatement.unmaskList(this.keyDefinition, QName.class);
    }

    public final Optional<DataSchemaNode> findDataChildByName(QName name) {
        return this.findDataSchemaNode(name);
    }

    public final Collection<? extends UniqueEffectiveStatement> getUniqueConstraints() {
        return (Collection)this.effectiveSubstatements().stream().filter(UniqueEffectiveStatement.class::isInstance).map(UniqueEffectiveStatement.class::cast).collect(ImmutableList.toImmutableList());
    }

    public final ListEffectiveStatement asEffectiveStatement() {
        return this;
    }

    public final String toString() {
        return "list " + this.getQName().getLocalName();
    }
}

