/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.max_elements;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.MaxElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MaxElementsStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStringStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.max_elements.EmptyMaxElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.max_elements.EmptyMaxElementsStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.max_elements.RegularMaxElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.max_elements.RegularMaxElementsStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class MaxElementsStatementSupport
extends BaseStringStatementSupport<MaxElementsStatement, MaxElementsEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MAX_ELEMENTS).build();
    private static final MaxElementsStatementSupport INSTANCE = new MaxElementsStatementSupport();

    private MaxElementsStatementSupport() {
        super((StatementDefinition)YangStmtMapping.MAX_ELEMENTS);
    }

    public static MaxElementsStatementSupport getInstance() {
        return INSTANCE;
    }

    public String internArgument(String rawArgument) {
        return "unbounded".equals(rawArgument) ? "unbounded" : rawArgument;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected MaxElementsStatement createDeclared(StmtContext<String, MaxElementsStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularMaxElementsStatement(ctx, substatements);
    }

    @Override
    protected MaxElementsStatement createEmptyDeclared(StmtContext<String, MaxElementsStatement, ?> ctx) {
        return new EmptyMaxElementsStatement(ctx);
    }

    @Override
    protected MaxElementsEffectiveStatement createEffective(StmtContext<String, MaxElementsStatement, MaxElementsEffectiveStatement> ctx, MaxElementsStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularMaxElementsEffectiveStatement(declared, substatements);
    }

    @Override
    protected MaxElementsEffectiveStatement createEmptyEffective(StmtContext<String, MaxElementsStatement, MaxElementsEffectiveStatement> ctx, MaxElementsStatement declared) {
        return new EmptyMaxElementsEffectiveStatement(declared);
    }
}

