/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnqualifiedQName;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module.ModuleEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.module.ModuleStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.ModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.NamespaceToModule;
import org.opendaylight.yangtools.yang.parser.spi.PreLinkageModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.SemanticVersionModuleNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.SemanticVersionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedSubmoduleNameToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToSourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNameToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleNamespaceForBelongsTo;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleQNameToModuleName;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

abstract class AbstractModuleStatementSupport
extends BaseStatementSupport<UnqualifiedQName, ModuleStatement, ModuleEffectiveStatement> {
    AbstractModuleStatementSupport() {
        super((StatementDefinition)YangStmtMapping.MODULE);
    }

    public final UnqualifiedQName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return UnqualifiedQName.of((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(e.getMessage(), ctx.getStatementSourceReference(), (Throwable)e);
        }
    }

    public final void onPreLinkageDeclared(StmtContext.Mutable<UnqualifiedQName, ModuleStatement, ModuleEffectiveStatement> stmt) {
        String moduleName = stmt.coerceRawStatementArgument();
        URI moduleNs = (URI)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), NamespaceStatement.class);
        SourceException.throwIfNull((Object)moduleNs, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Namespace of the module [%s] is missing", (Object[])new Object[]{moduleName});
        stmt.addToNs(ModuleNameToNamespace.class, (Object)moduleName, (Object)moduleNs);
        String modulePrefix = (String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class);
        SourceException.throwIfNull((Object)modulePrefix, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Prefix of the module [%s] is missing", (Object[])new Object[]{moduleName});
        stmt.addToNs(ImpPrefixToNamespace.class, (Object)modulePrefix, (Object)moduleNs);
        stmt.addContext(PreLinkageModuleNamespace.class, (Object)moduleName, stmt);
        Optional revisionDate = StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements());
        QNameModule qNameModule = QNameModule.create((URI)moduleNs, (Revision)revisionDate.orElse(null)).intern();
        stmt.addToNs(ModuleCtxToModuleQName.class, stmt, (Object)qNameModule);
        stmt.setRootIdentifier((SourceIdentifier)RevisionSourceIdentifier.create((String)((UnqualifiedQName)stmt.coerceStatementArgument()).getLocalName(), (Optional)revisionDate));
    }

    public final void onLinkageDeclared(StmtContext.Mutable<UnqualifiedQName, ModuleStatement, ModuleEffectiveStatement> stmt) {
        Optional<URI> moduleNs = Optional.ofNullable((URI)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), NamespaceStatement.class));
        SourceException.throwIf((!moduleNs.isPresent() ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Namespace of the module [%s] is missing", (Object[])new Object[]{stmt.getStatementArgument()});
        Optional revisionDate = StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements());
        QNameModule qNameModule = QNameModule.create((URI)moduleNs.get(), (Revision)revisionDate.orElse(null)).intern();
        StmtContext possibleDuplicateModule = (StmtContext)stmt.getFromNamespace(NamespaceToModule.class, (Object)qNameModule);
        if (possibleDuplicateModule != null && possibleDuplicateModule != stmt) {
            throw new SourceException(stmt.getStatementSourceReference(), "Module namespace collision: %s. At %s", new Object[]{qNameModule.getNamespace(), possibleDuplicateModule.getStatementSourceReference()});
        }
        String moduleName = stmt.coerceRawStatementArgument();
        RevisionSourceIdentifier moduleIdentifier = RevisionSourceIdentifier.create((String)moduleName, (Optional)revisionDate);
        stmt.addContext(ModuleNamespace.class, (Object)moduleIdentifier, stmt);
        stmt.addContext(ModuleNamespaceForBelongsTo.class, (Object)moduleIdentifier.getName(), stmt);
        stmt.addContext(NamespaceToModule.class, (Object)qNameModule, stmt);
        String modulePrefix = (String)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), PrefixStatement.class);
        SourceException.throwIfNull((Object)modulePrefix, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Prefix of the module [%s] is missing", (Object[])new Object[]{stmt.getStatementArgument()});
        stmt.addToNs(PrefixToModule.class, (Object)modulePrefix, (Object)qNameModule);
        stmt.addToNs(ModuleNameToModuleQName.class, (Object)moduleName, (Object)qNameModule);
        stmt.addToNs(ModuleCtxToModuleQName.class, stmt, (Object)qNameModule);
        stmt.addToNs(ModuleCtxToSourceIdentifier.class, stmt, (Object)moduleIdentifier);
        stmt.addToNs(ModuleQNameToModuleName.class, (Object)qNameModule, (Object)moduleName);
        stmt.addToNs(ImportPrefixToModuleCtx.class, (Object)modulePrefix, stmt);
        if (stmt.isEnabledSemanticVersioning()) {
            AbstractModuleStatementSupport.addToSemVerModuleNamespace(stmt, (SourceIdentifier)moduleIdentifier);
        }
    }

    @Override
    protected final ImmutableList<? extends EffectiveStatement<?, ?>> buildEffectiveSubstatements(StmtContext<UnqualifiedQName, ModuleStatement, ModuleEffectiveStatement> ctx, List<? extends StmtContext<?, ?, ?>> substatements) {
        ImmutableList<EffectiveStatement<?, ?>> local = super.buildEffectiveSubstatements(ctx, substatements);
        Collection<StmtContext<?, ?, ?>> submodules = AbstractModuleStatementSupport.submoduleContexts(ctx);
        if (submodules.isEmpty()) {
            return local;
        }
        ArrayList<EffectiveStatement> others = new ArrayList<EffectiveStatement>();
        for (StmtContext<?, ?, ?> submoduleCtx : submodules) {
            for (EffectiveStatement effective : submoduleCtx.buildEffective().effectiveSubstatements()) {
                if (!(effective instanceof SchemaNode) && !(effective instanceof DataNodeContainer)) continue;
                others.add(effective);
            }
        }
        return ImmutableList.builderWithExpectedSize((int)(local.size() + others.size())).addAll(local).addAll(others).build();
    }

    @Override
    protected final ModuleStatement createDeclared(StmtContext<UnqualifiedQName, ModuleStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new ModuleStatementImpl(ctx, substatements);
    }

    @Override
    protected final ModuleStatement createEmptyDeclared(StmtContext<UnqualifiedQName, ModuleStatement, ?> ctx) {
        throw AbstractModuleStatementSupport.noNamespace(ctx);
    }

    @Override
    protected final ModuleEffectiveStatement createEffective(StmtContext<UnqualifiedQName, ModuleStatement, ModuleEffectiveStatement> ctx, ModuleStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        ArrayList<Submodule> submodules = new ArrayList<Submodule>();
        for (StmtContext<?, ?, ?> submoduleCtx : AbstractModuleStatementSupport.submoduleContexts(ctx)) {
            EffectiveStatement submodule = submoduleCtx.buildEffective();
            Verify.verify((boolean)(submodule instanceof Submodule), (String)"Submodule statement %s is not a Submodule", (Object)submodule);
            submodules.add((Submodule)submodule);
        }
        return new ModuleEffectiveStatementImpl(ctx, declared, substatements, submodules);
    }

    @Override
    protected final ModuleEffectiveStatement createEmptyEffective(StmtContext<UnqualifiedQName, ModuleStatement, ModuleEffectiveStatement> ctx, ModuleStatement declared) {
        throw AbstractModuleStatementSupport.noNamespace(ctx);
    }

    private static Collection<StmtContext<?, ?, ?>> submoduleContexts(StmtContext<?, ?, ?> ctx) {
        Map submodules = ctx.getAllFromCurrentStmtCtxNamespace(IncludedSubmoduleNameToModuleCtx.class);
        return submodules == null ? List.of() : submodules.values();
    }

    private static SourceException noNamespace(StmtContext<?, ?, ?> ctx) {
        return new SourceException("No namespace declared in module", ctx.getStatementSourceReference());
    }

    private static void addToSemVerModuleNamespace(StmtContext.Mutable<UnqualifiedQName, ModuleStatement, ModuleEffectiveStatement> stmt, SourceIdentifier moduleIdentifier) {
        SemVerSourceIdentifier id = SemVerSourceIdentifier.create((String)stmt.coerceRawStatementArgument(), (SemVer)((SemVer)stmt.getFromNamespace(SemanticVersionNamespace.class, stmt)));
        stmt.addToNs(SemanticVersionModuleNamespace.class, (Object)id, stmt);
    }
}

