/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.namespace;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.namespace.EmptyNamespaceEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.namespace.EmptyNamespaceStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.namespace.RegularNamespaceEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.namespace.RegularNamespaceStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class NamespaceStatementSupport
extends BaseStatementSupport<URI, NamespaceStatement, NamespaceEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.NAMESPACE).build();
    private static final NamespaceStatementSupport INSTANCE = new NamespaceStatementSupport();

    private NamespaceStatementSupport() {
        super((StatementDefinition)YangStmtMapping.NAMESPACE);
    }

    public static NamespaceStatementSupport getInstance() {
        return INSTANCE;
    }

    public URI parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid namespace \"%s\"", new Object[]{value});
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected NamespaceStatement createDeclared(@NonNull StmtContext<URI, NamespaceStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularNamespaceStatement((URI)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected NamespaceStatement createEmptyDeclared(StmtContext<URI, NamespaceStatement, ?> ctx) {
        return new EmptyNamespaceStatement((URI)ctx.coerceStatementArgument());
    }

    @Override
    protected NamespaceEffectiveStatement createEffective(StmtContext<URI, NamespaceStatement, NamespaceEffectiveStatement> ctx, NamespaceStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularNamespaceEffectiveStatement(declared, substatements);
    }

    @Override
    protected NamespaceEffectiveStatement createEmptyEffective(StmtContext<URI, NamespaceStatement, NamespaceEffectiveStatement> ctx, NamespaceStatement declared) {
        return new EmptyNamespaceEffectiveStatement(declared);
    }
}

