/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ordered_by;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrderedByStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ordered_by.EmptyOrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ordered_by.EmptyOrderedByStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ordered_by.RegularOrderedByEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ordered_by.RegularOrderedByStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class OrderedByStatementSupport
extends BaseStatementSupport<OrderedByStatement.Ordering, OrderedByStatement, OrderedByEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.ORDERED_BY).build();
    private static final OrderedByStatementSupport INSTANCE = new OrderedByStatementSupport();
    private static final @NonNull EmptyOrderedByStatement EMPTY_SYSTEM_DECL = new EmptyOrderedByStatement(OrderedByStatement.Ordering.SYSTEM);
    private static final @NonNull EmptyOrderedByStatement EMPTY_USER_DECL = new EmptyOrderedByStatement(OrderedByStatement.Ordering.USER);
    private static final @NonNull EmptyOrderedByEffectiveStatement EMPTY_SYSTEM_EFF = new EmptyOrderedByEffectiveStatement(EMPTY_SYSTEM_DECL);
    private static final @NonNull EmptyOrderedByEffectiveStatement EMPTY_USER_EFF = new EmptyOrderedByEffectiveStatement(EMPTY_USER_DECL);

    private OrderedByStatementSupport() {
        super((StatementDefinition)YangStmtMapping.ORDERED_BY, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public static OrderedByStatementSupport getInstance() {
        return INSTANCE;
    }

    public OrderedByStatement.Ordering parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return OrderedByStatement.Ordering.forArgumentString((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid ordered-by argument '%s'", new Object[]{value});
        }
    }

    public String internArgument(String rawArgument) {
        if ("user".equals(rawArgument)) {
            return "user";
        }
        if ("system".equals(rawArgument)) {
            return "system";
        }
        return rawArgument;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected OrderedByStatement createDeclared(StmtContext<OrderedByStatement.Ordering, OrderedByStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularOrderedByStatement((OrderedByStatement.Ordering)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected OrderedByStatement createEmptyDeclared(StmtContext<OrderedByStatement.Ordering, OrderedByStatement, ?> ctx) {
        OrderedByStatement.Ordering argument = (OrderedByStatement.Ordering)ctx.coerceStatementArgument();
        switch (argument) {
            case SYSTEM: {
                return EMPTY_SYSTEM_DECL;
            }
            case USER: {
                return EMPTY_USER_DECL;
            }
        }
        throw new IllegalStateException("Unhandled argument " + argument);
    }

    @Override
    protected OrderedByEffectiveStatement createEffective(StmtContext<OrderedByStatement.Ordering, OrderedByStatement, OrderedByEffectiveStatement> ctx, OrderedByStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularOrderedByEffectiveStatement(declared, substatements);
    }

    @Override
    protected OrderedByEffectiveStatement createEmptyEffective(StmtContext<OrderedByStatement.Ordering, OrderedByStatement, OrderedByEffectiveStatement> ctx, OrderedByStatement declared) {
        if (EMPTY_USER_DECL.equals(declared)) {
            return EMPTY_USER_EFF;
        }
        if (EMPTY_SYSTEM_DECL.equals(declared)) {
            return EMPTY_SYSTEM_EFF;
        }
        return new EmptyOrderedByEffectiveStatement(declared);
    }
}

