/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseOperationContainerStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output.DeclaredOutputEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output.EmptyOutputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output.EmptyUndeclaredOutputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output.RegularOutputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output.RegularUndeclaredOutputStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.output.UndeclaredOutputEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

abstract class AbstractOutputStatementSupport
extends BaseOperationContainerStatementSupport<OutputStatement, OutputEffectiveStatement> {
    AbstractOutputStatementSupport() {
        super((StatementDefinition)YangStmtMapping.OUTPUT, YangConstants::operationOutputQName);
    }

    @Override
    protected final OutputStatement createDeclared(StmtContext<QName, OutputStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        StatementSource source = ctx.getStatementSource();
        switch (ctx.getStatementSource()) {
            case CONTEXT: {
                return new RegularUndeclaredOutputStatement((QName)ctx.coerceStatementArgument(), substatements);
            }
            case DECLARATION: {
                return new RegularOutputStatement((QName)ctx.coerceStatementArgument(), substatements);
            }
        }
        throw new IllegalStateException("Unhandled statement source " + source);
    }

    @Override
    protected final OutputStatement createEmptyDeclared(StmtContext<QName, OutputStatement, ?> ctx) {
        StatementSource source = ctx.getStatementSource();
        switch (ctx.getStatementSource()) {
            case CONTEXT: {
                return new EmptyUndeclaredOutputStatement((QName)ctx.coerceStatementArgument());
            }
            case DECLARATION: {
                return new EmptyOutputStatement((QName)ctx.coerceStatementArgument());
            }
        }
        throw new IllegalStateException("Unhandled statement source " + source);
    }

    @Override
    protected final OutputEffectiveStatement createDeclaredEffective(int flags, StmtContext<QName, OutputStatement, OutputEffectiveStatement> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, OutputStatement declared) {
        return new DeclaredOutputEffectiveStatement(declared, flags, ctx, substatements);
    }

    @Override
    protected final OutputEffectiveStatement createUndeclaredEffective(int flags, StmtContext<QName, OutputStatement, OutputEffectiveStatement> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new UndeclaredOutputEffectiveStatement(flags, ctx, substatements);
    }
}

