/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern;

import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternExpression;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternStatement;
import org.opendaylight.yangtools.yang.model.util.RegexUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.EmptyPatternEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.EmptyPatternStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.RegularPatternEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.RegularPatternStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

abstract class AbstractPatternStatementSupport
extends BaseStatementSupport<PatternExpression, PatternStatement, PatternEffectiveStatement> {
    AbstractPatternStatementSupport() {
        super((StatementDefinition)YangStmtMapping.PATTERN, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public final PatternExpression parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        String pattern = RegexUtils.getJavaRegexFromXSD((String)value);
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Pattern \"%s\" failed to compile", new Object[]{pattern});
        }
        return PatternExpression.of((String)value, (String)pattern);
    }

    @Override
    protected final PatternStatement createDeclared(StmtContext<PatternExpression, PatternStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularPatternStatement((PatternExpression)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final PatternStatement createEmptyDeclared(StmtContext<PatternExpression, PatternStatement, ?> ctx) {
        return new EmptyPatternStatement((PatternExpression)ctx.coerceStatementArgument());
    }

    @Override
    protected final PatternEffectiveStatement createEffective(StmtContext<PatternExpression, PatternStatement, PatternEffectiveStatement> ctx, PatternStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularPatternEffectiveStatement(declared, substatements);
    }

    @Override
    protected final PatternEffectiveStatement createEmptyEffective(StmtContext<PatternExpression, PatternStatement, PatternEffectiveStatement> ctx, PatternStatement declared) {
        return new EmptyPatternEffectiveStatement(declared);
    }
}

