/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.range;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnresolvedNumber;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueRange;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.range.EmptyRangeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.range.EmptyRangeStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.range.RegularRangeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.range.RegularRangeStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class RangeStatementSupport
extends BaseStatementSupport<List<ValueRange>, RangeStatement, RangeEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.RANGE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.ERROR_APP_TAG).addOptional((StatementDefinition)YangStmtMapping.ERROR_MESSAGE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();
    private static final RangeStatementSupport INSTANCE = new RangeStatementSupport();

    private RangeStatementSupport() {
        super((StatementDefinition)YangStmtMapping.RANGE);
    }

    public static RangeStatementSupport getInstance() {
        return INSTANCE;
    }

    public ImmutableList<ValueRange> parseArgumentValue(StmtContext<?, ?, ?> ctx, String rangeArgument) {
        ArrayList<ValueRange> ranges = new ArrayList<ValueRange>();
        for (String singleRange : ArgumentUtils.PIPE_SPLITTER.split((CharSequence)rangeArgument)) {
            Number max;
            Iterator boundaries = ArgumentUtils.TWO_DOTS_SPLITTER.split((CharSequence)singleRange).iterator();
            Number min = RangeStatementSupport.parseDecimalConstraintValue(ctx, (String)boundaries.next());
            if (boundaries.hasNext()) {
                max = RangeStatementSupport.parseDecimalConstraintValue(ctx, (String)boundaries.next());
                SourceException.throwIf((ArgumentUtils.compareNumbers(min, max) == 1 ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Range constraint %s has descending order of boundaries; should be ascending", (Object[])new Object[]{singleRange});
                SourceException.throwIf((boolean)boundaries.hasNext(), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Wrong number of boundaries in range constraint %s", (Object[])new Object[]{singleRange});
            } else {
                max = min;
            }
            InferenceException.throwIf((ranges.size() > 1 && ArgumentUtils.compareNumbers(min, ((ValueRange)Iterables.getLast(ranges)).upperBound()) != 1 ? 1 : 0) != 0, (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Some of the value ranges in %s are not disjoint", (Object[])new Object[]{rangeArgument});
            ranges.add(ValueRange.of((Number)min, (Number)max));
        }
        return ImmutableList.copyOf(ranges);
    }

    @Override
    protected RangeStatement createDeclared(StmtContext<List<ValueRange>, RangeStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularRangeStatement(ctx, substatements);
    }

    @Override
    protected RangeStatement createEmptyDeclared(StmtContext<List<ValueRange>, RangeStatement, ?> ctx) {
        return new EmptyRangeStatement(ctx);
    }

    @Override
    protected RangeEffectiveStatement createEffective(StmtContext<List<ValueRange>, RangeStatement, RangeEffectiveStatement> ctx, RangeStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularRangeEffectiveStatement(declared, substatements);
    }

    @Override
    protected RangeEffectiveStatement createEmptyEffective(StmtContext<List<ValueRange>, RangeStatement, RangeEffectiveStatement> ctx, RangeStatement declared) {
        return new EmptyRangeEffectiveStatement(declared);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    private static Number parseDecimalConstraintValue(StmtContext<?, ?, ?> ctx, String value) {
        if ("max".equals(value)) {
            return UnresolvedNumber.max();
        }
        if ("min".equals(value)) {
            return UnresolvedNumber.min();
        }
        try {
            return value.indexOf(46) != -1 ? new BigDecimal(value) : new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException(String.format("Value %s is not a valid decimal number", value), ctx.getStatementSourceReference(), (Throwable)e);
        }
    }
}

