/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision;

import com.google.common.collect.ImmutableList;
import java.time.format.DateTimeParseException;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision.EmptyRevisionEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision.EmptyRevisionStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision.RegularRevisionEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.revision.RegularRevisionStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class RevisionStatementSupport
extends BaseStatementSupport<Revision, RevisionStatement, RevisionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.REVISION).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();
    private static final RevisionStatementSupport INSTANCE = new RevisionStatementSupport();

    private RevisionStatementSupport() {
        super((StatementDefinition)YangStmtMapping.REVISION);
    }

    public static RevisionStatementSupport getInstance() {
        return INSTANCE;
    }

    public Revision parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Revision.of((String)value);
        }
        catch (DateTimeParseException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Revision value %s is not in required format yyyy-MM-dd", new Object[]{value});
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected RevisionStatement createDeclared(StmtContext<Revision, RevisionStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularRevisionStatement((Revision)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected RevisionStatement createEmptyDeclared(StmtContext<Revision, RevisionStatement, ?> ctx) {
        return new EmptyRevisionStatement((Revision)ctx.coerceStatementArgument());
    }

    @Override
    protected RevisionEffectiveStatement createEffective(StmtContext<Revision, RevisionStatement, RevisionEffectiveStatement> ctx, RevisionStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularRevisionEffectiveStatement(declared, substatements);
    }

    @Override
    protected RevisionEffectiveStatement createEmptyEffective(StmtContext<Revision, RevisionStatement, RevisionEffectiveStatement> ctx, RevisionStatement declared) {
        return new EmptyRevisionEffectiveStatement(declared);
    }
}

