/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.rpc;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.InputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.rpc.EmptyRpcStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.rpc.RegularRpcStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.rpc.RpcEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;

abstract class AbstractRpcStatementSupport
extends BaseSchemaTreeStatementSupport<RpcStatement, RpcEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.RPC).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.INPUT).addOptional((StatementDefinition)YangStmtMapping.OUTPUT).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).build();

    AbstractRpcStatementSupport() {
        super((StatementDefinition)YangStmtMapping.RPC);
    }

    public final void onFullDefinitionDeclared(StmtContext.Mutable<QName, RpcStatement, RpcEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, InputStatement.class) == null) {
            ((StatementContextBase)stmt).appendImplicitSubstatement(this.implictInput(), null);
        }
        if (StmtContextUtils.findFirstDeclaredSubstatement(stmt, OutputStatement.class) == null) {
            ((StatementContextBase)stmt).appendImplicitSubstatement(this.implictOutput(), null);
        }
    }

    protected final SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected final RpcStatement createDeclared(StmtContext<QName, RpcStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularRpcStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected final RpcStatement createEmptyDeclared(StmtContext<QName, RpcStatement, ?> ctx) {
        return new EmptyRpcStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected final RpcEffectiveStatement createEffective(StmtContext<QName, RpcStatement, RpcEffectiveStatement> ctx, RpcStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RpcEffectiveStatementImpl(declared, (SchemaPath)ctx.getSchemaPath().get(), AbstractRpcStatementSupport.computeFlags(ctx, substatements), ctx, substatements);
    }

    @Override
    protected final RpcEffectiveStatement createEmptyEffective(StmtContext<QName, RpcStatement, RpcEffectiveStatement> ctx, RpcStatement declared) {
        throw new IllegalStateException("Missing implicit input/output statements at " + ctx.getStatementSourceReference());
    }

    abstract StatementSupport<?, ?, ?> implictInput();

    abstract StatementSupport<?, ?, ?> implictOutput();

    private static int computeFlags(StmtContext<?, ?, ?> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus(AbstractRpcStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).toFlags();
    }
}

