/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.status;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.status.EmptyStatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.status.EmptyStatusStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.status.RegularStatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.status.RegularStatusStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class StatusStatementSupport
extends BaseStatementSupport<Status, StatusStatement, StatusEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.STATUS).build();
    private static final StatusStatementSupport INSTANCE = new StatusStatementSupport();
    private static final @NonNull EmptyStatusStatement EMPTY_CURRENT_DECL = new EmptyStatusStatement(Status.CURRENT);
    private static final @NonNull EmptyStatusStatement EMPTY_DEPRECATED_DECL = new EmptyStatusStatement(Status.DEPRECATED);
    private static final @NonNull EmptyStatusStatement EMPTY_OBSOLETE_DECL = new EmptyStatusStatement(Status.OBSOLETE);
    private static final @NonNull EmptyStatusEffectiveStatement EMPTY_CURRENT_EFF = new EmptyStatusEffectiveStatement(EMPTY_CURRENT_DECL);
    private static final @NonNull EmptyStatusEffectiveStatement EMPTY_DEPRECATED_EFF = new EmptyStatusEffectiveStatement(EMPTY_DEPRECATED_DECL);
    private static final @NonNull EmptyStatusEffectiveStatement EMPTY_OBSOLETE_EFF = new EmptyStatusEffectiveStatement(EMPTY_OBSOLETE_DECL);

    private StatusStatementSupport() {
        super((StatementDefinition)YangStmtMapping.STATUS, StatementSupport.CopyPolicy.CONTEXT_INDEPENDENT);
    }

    public static StatusStatementSupport getInstance() {
        return INSTANCE;
    }

    public Status parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        switch (value) {
            case "current": {
                return Status.CURRENT;
            }
            case "deprecated": {
                return Status.DEPRECATED;
            }
            case "obsolete": {
                return Status.OBSOLETE;
            }
        }
        throw new SourceException(ctx.getStatementSourceReference(), "Invalid status '%s', must be one of 'current', 'deprecated' or 'obsolete'", new Object[]{value});
    }

    public String internArgument(String rawArgument) {
        if ("current".equals(rawArgument)) {
            return "current";
        }
        if ("deprecated".equals(rawArgument)) {
            return "deprecated";
        }
        if ("obsolete".equals(rawArgument)) {
            return "obsolete";
        }
        return rawArgument;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected StatusStatement createDeclared(StmtContext<Status, StatusStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularStatusStatement((Status)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected StatusStatement createEmptyDeclared(StmtContext<Status, StatusStatement, ?> ctx) {
        Status argument = (Status)ctx.coerceStatementArgument();
        switch (argument) {
            case CURRENT: {
                return EMPTY_CURRENT_DECL;
            }
            case DEPRECATED: {
                return EMPTY_DEPRECATED_DECL;
            }
            case OBSOLETE: {
                return EMPTY_OBSOLETE_DECL;
            }
        }
        throw new IllegalStateException("Unhandled argument " + argument);
    }

    @Override
    protected StatusEffectiveStatement createEffective(StmtContext<Status, StatusStatement, StatusEffectiveStatement> ctx, StatusStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularStatusEffectiveStatement(declared, substatements);
    }

    @Override
    protected StatusEffectiveStatement createEmptyEffective(StmtContext<Status, StatusStatement, StatusEffectiveStatement> ctx, StatusStatement declared) {
        if (EMPTY_DEPRECATED_DECL.equals(declared)) {
            return EMPTY_DEPRECATED_EFF;
        }
        if (EMPTY_OBSOLETE_DECL.equals(declared)) {
            return EMPTY_OBSOLETE_EFF;
        }
        if (EMPTY_CURRENT_DECL.equals(declared)) {
            return EMPTY_CURRENT_EFF;
        }
        return new EmptyStatusEffectiveStatement(declared);
    }
}

