/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BitEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.BitsSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EffectiveTypeUtil;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

final class BitsSpecificationSupport
extends BaseStatementSupport<String, TypeStatement.BitsSpecification, EffectiveStatement<String, TypeStatement.BitsSpecification>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMultiple((StatementDefinition)YangStmtMapping.BIT).build();

    BitsSpecificationSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected TypeStatement.BitsSpecification createDeclared(StmtContext<String, TypeStatement.BitsSpecification, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new BitsSpecificationImpl(ctx, substatements);
    }

    @Override
    protected TypeStatement.BitsSpecification createEmptyDeclared(StmtContext<String, TypeStatement.BitsSpecification, ?> ctx) {
        throw BitsSpecificationSupport.noBits(ctx);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.BitsSpecification> createEffective(StmtContext<String, TypeStatement.BitsSpecification, EffectiveStatement<String, TypeStatement.BitsSpecification>> ctx, TypeStatement.BitsSpecification declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        BitsTypeBuilder builder = BaseTypes.bitsTypeBuilder((SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        Uint32 highestPosition = null;
        for (EffectiveStatement stmt : substatements) {
            Uint32 effectivePos;
            if (!(stmt instanceof BitEffectiveStatement)) continue;
            BitEffectiveStatement bitSubStmt = (BitEffectiveStatement)stmt;
            Optional declaredPosition = bitSubStmt.getDeclaredPosition();
            if (declaredPosition.isEmpty()) {
                if (highestPosition != null) {
                    SourceException.throwIf((boolean)Uint32.MAX_VALUE.equals(highestPosition), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Bit %s must have a position statement", (Object[])new Object[]{bitSubStmt});
                    effectivePos = Uint32.fromIntBits((int)(highestPosition.intValue() + 1));
                } else {
                    effectivePos = Uint32.ZERO;
                }
            } else {
                effectivePos = (Uint32)declaredPosition.get();
            }
            BitsTypeDefinition.Bit bit = EffectiveTypeUtil.buildBit(bitSubStmt, effectivePos);
            if (highestPosition == null || highestPosition.compareTo(bit.getPosition()) < 0) {
                highestPosition = bit.getPosition();
            }
            builder.addBit(bit);
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.BitsSpecification> createEmptyEffective(StmtContext<String, TypeStatement.BitsSpecification, EffectiveStatement<String, TypeStatement.BitsSpecification>> ctx, TypeStatement.BitsSpecification declared) {
        throw BitsSpecificationSupport.noBits(ctx);
    }

    private static SourceException noBits(StmtContext<?, ?, ?> ctx) {
        return new SourceException("At least one bit statement has to be present", ctx.getStatementSourceReference());
    }
}

