/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;

enum BuiltinEffectiveStatement implements TypeEffectiveStatement<TypeStatement>
{
    BINARY((TypeDefinition<?>)BaseTypes.binaryType()),
    BOOLEAN((TypeDefinition<?>)BaseTypes.booleanType()),
    EMPTY((TypeDefinition<?>)BaseTypes.emptyType()),
    INSTANCE_IDENTIFIER((TypeDefinition<?>)BaseTypes.instanceIdentifierType()),
    INT8((TypeDefinition<?>)BaseTypes.int8Type()),
    INT16((TypeDefinition<?>)BaseTypes.int16Type()),
    INT32((TypeDefinition<?>)BaseTypes.int32Type()),
    INT64((TypeDefinition<?>)BaseTypes.int64Type()),
    STRING((TypeDefinition<?>)BaseTypes.stringType()),
    UINT8((TypeDefinition<?>)BaseTypes.uint8Type()),
    UINT16((TypeDefinition<?>)BaseTypes.uint16Type()),
    UINT32((TypeDefinition<?>)BaseTypes.uint32Type()),
    UINT64((TypeDefinition<?>)BaseTypes.uint64Type());

    private final @NonNull TypeDefinition<?> typedef;

    private BuiltinEffectiveStatement(TypeDefinition<?> typedef) {
        this.typedef = Objects.requireNonNull(typedef);
    }

    public TypeDefinition<?> getTypeDefinition() {
        return this.typedef;
    }

    public final TypeStatement getDeclared() {
        return null;
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends V> get(Class<N> namespace, K identifier) {
        return Optional.empty();
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAll(Class<N> namespace) {
        return ImmutableMap.of();
    }

    public final Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return ImmutableList.of();
    }

    public final String argument() {
        return this.getTypeDefinition().getQName().getLocalName();
    }

    public final StatementSource getStatementSource() {
        return StatementSource.CONTEXT;
    }
}

