/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.InstanceIdentifierTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.EmptyIdentifierSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.RegularInstanceIdentifierSpecification;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

final class InstanceIdentifierSpecificationSupport
extends BaseStatementSupport<String, TypeStatement.InstanceIdentifierSpecification, EffectiveStatement<String, TypeStatement.InstanceIdentifierSpecification>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.REQUIRE_INSTANCE).build();

    InstanceIdentifierSpecificationSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected TypeStatement.InstanceIdentifierSpecification createDeclared(StmtContext<String, TypeStatement.InstanceIdentifierSpecification, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularInstanceIdentifierSpecification(ctx, substatements);
    }

    @Override
    protected TypeStatement.InstanceIdentifierSpecification createEmptyDeclared(StmtContext<String, TypeStatement.InstanceIdentifierSpecification, ?> ctx) {
        return new EmptyIdentifierSpecification(ctx);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.InstanceIdentifierSpecification> createEffective(StmtContext<String, TypeStatement.InstanceIdentifierSpecification, EffectiveStatement<String, TypeStatement.InstanceIdentifierSpecification>> ctx, TypeStatement.InstanceIdentifierSpecification declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        InstanceIdentifierTypeBuilder builder = RestrictedTypes.newInstanceIdentifierBuilder((InstanceIdentifierTypeDefinition)BaseTypes.instanceIdentifierType(), (SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof RequireInstanceEffectiveStatement)) continue;
            builder.setRequireInstance(((Boolean)((RequireInstanceEffectiveStatement)stmt).argument()).booleanValue());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.InstanceIdentifierSpecification> createEmptyEffective(StmtContext<String, TypeStatement.InstanceIdentifierSpecification, EffectiveStatement<String, TypeStatement.InstanceIdentifierSpecification>> ctx, TypeStatement.InstanceIdentifierSpecification declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }
}

