/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.UnionTypeBuilder;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.TypeEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type.UnionSpecificationImpl;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class UnionSpecificationSupport
extends BaseStatementSupport<String, TypeStatement.UnionSpecification, EffectiveStatement<String, TypeStatement.UnionSpecification>> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPE).addMultiple((StatementDefinition)YangStmtMapping.TYPE).build();

    UnionSpecificationSupport() {
        super((StatementDefinition)YangStmtMapping.TYPE);
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected TypeStatement.UnionSpecification createDeclared(StmtContext<String, TypeStatement.UnionSpecification, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new UnionSpecificationImpl(ctx, substatements);
    }

    @Override
    protected TypeStatement.UnionSpecification createEmptyDeclared(StmtContext<String, TypeStatement.UnionSpecification, ?> ctx) {
        throw UnionSpecificationSupport.noType(ctx);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.UnionSpecification> createEffective(StmtContext<String, TypeStatement.UnionSpecification, EffectiveStatement<String, TypeStatement.UnionSpecification>> ctx, TypeStatement.UnionSpecification declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        UnionTypeBuilder builder = BaseTypes.unionTypeBuilder((SchemaPath)((SchemaPath)ctx.getSchemaPath().get()));
        for (EffectiveStatement stmt : substatements) {
            if (!(stmt instanceof TypeEffectiveStatement)) continue;
            builder.addType(((TypeEffectiveStatement)stmt).getTypeDefinition());
        }
        return new TypeEffectiveStatementImpl(declared, (ImmutableList<? extends EffectiveStatement<?, ?>>)((ImmutableList<EffectiveStatement<?, ?>>)substatements), builder);
    }

    @Override
    protected EffectiveStatement<String, TypeStatement.UnionSpecification> createEmptyEffective(StmtContext<String, TypeStatement.UnionSpecification, EffectiveStatement<String, TypeStatement.UnionSpecification>> ctx, TypeStatement.UnionSpecification declared) {
        throw UnionSpecificationSupport.noType(ctx);
    }

    private static SourceException noType(StmtContext<?, ?, ?> ctx) {
        return new SourceException("At least one type statement has to be present", ctx.getStatementSourceReference());
    }
}

