/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.type.DerivedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.DerivedTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TypedefEffectiveStatementImpl
extends AbstractDeclaredEffectiveStatement.Default<QName, TypedefStatement>
implements TypedefEffectiveStatement,
EffectiveStatementMixins.SchemaNodeMixin<QName, TypedefStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(TypedefEffectiveStatementImpl.class);
    private static final VarHandle TYPE_DEFINITION;
    private static final VarHandle TYPE_STATEMENT;
    private final @NonNull Object substatements;
    private final @NonNull SchemaPath path;
    private final int flags;
    private volatile TypeDefinition<?> typeDefinition;
    private volatile ProxyTypeEffectiveStatement typeStatement;

    TypedefEffectiveStatementImpl(TypedefStatement declared, SchemaPath path, int flags, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        super(declared);
        this.path = Objects.requireNonNull(path);
        this.flags = flags;
        this.substatements = TypedefEffectiveStatementImpl.maskList(substatements);
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Deprecated
    public SchemaPath getPath() {
        return this.path;
    }

    public @NonNull QName argument() {
        return this.getQName();
    }

    public ImmutableList<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return TypedefEffectiveStatementImpl.unmaskList(this.substatements);
    }

    public TypeDefinition<?> getTypeDefinition() {
        TypeDefinition<?> existing = TYPE_DEFINITION.getAcquire(this);
        return existing != null ? existing : this.loadTypeDefinition();
    }

    public TypeEffectiveStatement<TypeStatement> asTypeEffectiveStatement() {
        ProxyTypeEffectiveStatement local = TYPE_STATEMENT.getAcquire(this);
        return local != null ? local : this.loadTypeStatement();
    }

    private @NonNull TypeDefinition<?> loadTypeDefinition() {
        TypeEffectiveStatement type = (TypeEffectiveStatement)this.findFirstEffectiveSubstatement(TypeEffectiveStatement.class).get();
        DerivedTypeBuilder builder = DerivedTypes.derivedTypeBuilder((TypeDefinition)type.getTypeDefinition(), (SchemaPath)this.path);
        for (EffectiveStatement stmt : this.effectiveSubstatements()) {
            if (stmt instanceof DefaultEffectiveStatement) {
                builder.setDefaultValue(((DefaultEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof DescriptionEffectiveStatement) {
                builder.setDescription((String)((DescriptionEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof ReferenceEffectiveStatement) {
                builder.setReference((String)((ReferenceEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof StatusEffectiveStatement) {
                builder.setStatus((Status)((StatusEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof UnitsEffectiveStatement) {
                builder.setUnits((String)((UnitsEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof UnknownSchemaNode) {
                builder.addUnknownSchemaNode((UnknownSchemaNode)stmt);
                continue;
            }
            if (stmt instanceof TypeEffectiveStatement) continue;
            LOG.debug("Ignoring statement {}", (Object)stmt);
        }
        TypeDefinition created = (TypeDefinition)builder.build();
        Object witness = TYPE_DEFINITION.compareAndExchangeRelease(this, null, created);
        return witness == null ? created : (TypeDefinition)witness;
    }

    private @NonNull ProxyTypeEffectiveStatement loadTypeStatement() {
        ProxyTypeEffectiveStatement created = new ProxyTypeEffectiveStatement();
        Object witness = TYPE_STATEMENT.compareAndExchangeRelease(this, null, created);
        return witness == null ? created : (ProxyTypeEffectiveStatement)witness;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            TYPE_DEFINITION = lookup.findVarHandle(TypedefEffectiveStatementImpl.class, "typeDefinition", TypeDefinition.class);
            TYPE_STATEMENT = lookup.findVarHandle(TypedefEffectiveStatementImpl.class, "typeStatement", ProxyTypeEffectiveStatement.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private final class ProxyTypeEffectiveStatement
    implements TypeEffectiveStatement<TypeStatement> {
        private ProxyTypeEffectiveStatement() {
        }

        public TypeStatement getDeclared() {
            return null;
        }

        public <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends V> get(Class<N> namespace, K identifier) {
            return TypedefEffectiveStatementImpl.this.get(namespace, identifier);
        }

        public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAll(Class<N> namespace) {
            return TypedefEffectiveStatementImpl.this.getAll(namespace);
        }

        public Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
            return TypedefEffectiveStatementImpl.this.effectiveSubstatements();
        }

        public String argument() {
            return TypedefEffectiveStatementImpl.this.getQName().getLocalName();
        }

        public StatementSource getStatementSource() {
            return StatementSource.CONTEXT;
        }

        public TypeDefinition<?> getTypeDefinition() {
            return TypedefEffectiveStatementImpl.this.getTypeDefinition();
        }
    }
}

