/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef.EmptyTypedefStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef.RegularTypedefStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.typedef.TypedefEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.TypeNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class TypedefStatementSupport
extends BaseQNameStatementSupport<TypedefStatement, TypedefEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.TYPEDEF).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    private static final TypedefStatementSupport INSTANCE = new TypedefStatementSupport();

    private TypedefStatementSupport() {
        super((StatementDefinition)YangStmtMapping.TYPEDEF);
    }

    public static TypedefStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<QName, TypedefStatement, TypedefEffectiveStatement> stmt) {
        StmtContext.Mutable parent;
        super.onFullDefinitionDeclared(stmt);
        if (stmt != null && (parent = stmt.getParentContext()) != null) {
            TypedefStatementSupport.checkConflict(parent, stmt);
            parent.addContext(TypeNamespace.class, (Object)((QName)stmt.coerceStatementArgument()), stmt);
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected TypedefStatement createDeclared(StmtContext<QName, TypedefStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        TypedefStatementSupport.checkDeclared(ctx);
        return new RegularTypedefStatement((QName)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected TypedefStatement createEmptyDeclared(StmtContext<QName, TypedefStatement, ?> ctx) {
        TypedefStatementSupport.checkDeclared(ctx);
        return new EmptyTypedefStatement((QName)ctx.coerceStatementArgument());
    }

    @Override
    protected TypedefEffectiveStatement createEffective(StmtContext<QName, TypedefStatement, TypedefEffectiveStatement> ctx, TypedefStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        TypeEffectiveStatement typeEffectiveStmt = TypedefStatementSupport.findFirstStatement(substatements, TypeEffectiveStatement.class);
        String dflt = TypedefStatementSupport.findFirstArgument(substatements, DefaultEffectiveStatement.class, null);
        SourceException.throwIf((boolean)EffectiveStmtUtils.hasDefaultValueMarkedWithIfFeature(ctx.getRootVersion(), typeEffectiveStmt, dflt), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Typedef '%s' has default value '%s' marked with an if-feature statement.", (Object[])new Object[]{ctx.getStatementArgument(), dflt});
        return new TypedefEffectiveStatementImpl(declared, (SchemaPath)ctx.getSchemaPath().get(), TypedefStatementSupport.computeFlags(substatements), substatements);
    }

    @Override
    protected TypedefEffectiveStatement createEmptyEffective(StmtContext<QName, TypedefStatement, TypedefEffectiveStatement> ctx, TypedefStatement declared) {
        throw new IllegalStateException("Refusing to create empty typedef for " + declared);
    }

    private static void checkConflict(StmtContext<?, ?, ?> parent, StmtContext<QName, ?, ?> stmt) {
        QName arg = (QName)stmt.coerceStatementArgument();
        StmtContext existing = (StmtContext)parent.getFromNamespace(TypeNamespace.class, (Object)arg);
        SourceException.throwIf((existing != null ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Duplicate name for typedef %s", (Object[])new Object[]{arg});
    }

    private static void checkDeclared(StmtContext<QName, TypedefStatement, ?> ctx) {
        StmtContext grandParent;
        StmtContext parent = ctx.getParentContext();
        if (parent != null && (grandParent = parent.getParentContext()) != null) {
            TypedefStatementSupport.checkConflict(grandParent, ctx);
        }
    }

    private static int computeFlags(ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setStatus(TypedefStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, Status.CURRENT)).toFlags();
    }
}

