/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.unique;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UniqueEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UniqueStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.ArgumentUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.unique.EmptyUniqueEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.unique.EmptyUniqueStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.unique.RegularUniqueEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.unique.RegularUniqueStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class UniqueStatementSupport
extends BaseStatementSupport<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement, UniqueEffectiveStatement> {
    private static final Pattern CRLF_PATTERN = Pattern.compile("\r\n", 16);
    private static final Splitter SEP_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" \t\n").precomputed()).omitEmptyStrings();
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.UNIQUE).build();
    private static final UniqueStatementSupport INSTANCE = new UniqueStatementSupport();

    private UniqueStatementSupport() {
        super((StatementDefinition)YangStmtMapping.UNIQUE);
    }

    public static UniqueStatementSupport getInstance() {
        return INSTANCE;
    }

    public ImmutableSet<SchemaNodeIdentifier.Descendant> parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        ImmutableSet<SchemaNodeIdentifier.Descendant> uniqueConstraints = UniqueStatementSupport.parseUniqueConstraintArgument(ctx, value);
        SourceException.throwIf((boolean)uniqueConstraints.isEmpty(), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Invalid argument value '%s' of unique statement. The value must contains at least one descendant schema node identifier.", (Object[])new Object[]{value});
        return uniqueConstraints;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected UniqueStatement createDeclared(StmtContext<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new RegularUniqueStatement(ctx, substatements);
    }

    @Override
    protected UniqueStatement createEmptyDeclared(StmtContext<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement, ?> ctx) {
        return new EmptyUniqueStatement(ctx);
    }

    @Override
    protected UniqueEffectiveStatement createEffective(StmtContext<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement, UniqueEffectiveStatement> ctx, UniqueStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new RegularUniqueEffectiveStatement(declared, substatements);
    }

    @Override
    protected UniqueEffectiveStatement createEmptyEffective(StmtContext<Set<SchemaNodeIdentifier.Descendant>, UniqueStatement, UniqueEffectiveStatement> ctx, UniqueStatement declared) {
        return new EmptyUniqueEffectiveStatement(declared);
    }

    private static ImmutableSet<SchemaNodeIdentifier.Descendant> parseUniqueConstraintArgument(StmtContext<?, ?, ?> ctx, String argumentValue) {
        String nocrlf = CRLF_PATTERN.matcher(argumentValue).replaceAll("\n");
        HashSet<SchemaNodeIdentifier.Descendant> uniqueConstraintNodes = new HashSet<SchemaNodeIdentifier.Descendant>();
        for (String uniqueArgToken : SEP_SPLITTER.split((CharSequence)nocrlf)) {
            SchemaNodeIdentifier nodeIdentifier = ArgumentUtils.nodeIdentifierFromPath(ctx, uniqueArgToken);
            SourceException.throwIf((boolean)(nodeIdentifier instanceof SchemaNodeIdentifier.Absolute), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unique statement argument '%s' contains schema node identifier '%s' which is not in the descendant node identifier form.", (Object[])new Object[]{argumentValue, uniqueArgToken});
            uniqueConstraintNodes.add((SchemaNodeIdentifier.Descendant)nodeIdentifier);
        }
        return ImmutableSet.copyOf(uniqueConstraintNodes);
    }
}

