/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6643.parser;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc6643.model.api.IetfYangSmiv2ExtensionsMapping;
import org.opendaylight.yangtools.rfc6643.model.api.ImpliedEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.ImpliedStatement;
import org.opendaylight.yangtools.rfc6643.parser.ImpliedEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc6643.parser.ImpliedStatementImpl;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStringStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public final class ImpliedStatementSupport
extends BaseStringStatementSupport<ImpliedStatement, ImpliedEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)IetfYangSmiv2ExtensionsMapping.IMPLIED).build();
    private static final ImpliedStatementSupport INSTANCE = new ImpliedStatementSupport();

    private ImpliedStatementSupport() {
        super((StatementDefinition)IetfYangSmiv2ExtensionsMapping.IMPLIED);
    }

    public static ImpliedStatementSupport getInstance() {
        return INSTANCE;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    protected ImpliedStatement createDeclared(StmtContext<String, ImpliedStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new ImpliedStatementImpl(ctx.coerceRawStatementArgument(), substatements);
    }

    protected ImpliedStatement createEmptyDeclared(StmtContext<String, ImpliedStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    protected ImpliedEffectiveStatement createEffective(StmtContext<String, ImpliedStatement, ImpliedEffectiveStatement> ctx, ImpliedStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new ImpliedEffectiveStatementImpl(declared, substatements, ctx);
    }

    protected ImpliedEffectiveStatement createEmptyEffective(StmtContext<String, ImpliedStatement, ImpliedEffectiveStatement> ctx, ImpliedStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }
}

