/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6643.parser;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc6643.model.api.IetfYangSmiv2ExtensionsMapping;
import org.opendaylight.yangtools.rfc6643.model.api.ObjectIdentifier;
import org.opendaylight.yangtools.rfc6643.model.api.OidEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.OidStatement;
import org.opendaylight.yangtools.rfc6643.parser.OidEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc6643.parser.OidIdStatementImpl;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class OidStatementSupport
extends BaseStatementSupport<ObjectIdentifier, OidStatement, OidEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)IetfYangSmiv2ExtensionsMapping.OBJECT_ID).build();
    private static final OidStatementSupport INSTANCE = new OidStatementSupport();

    private OidStatementSupport() {
        super((StatementDefinition)IetfYangSmiv2ExtensionsMapping.OBJECT_ID);
    }

    public static OidStatementSupport getInstance() {
        return INSTANCE;
    }

    public ObjectIdentifier parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return ObjectIdentifier.forString((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx.getStatementSourceReference(), (Throwable)e, "Invalid object identifier '%s'", new Object[]{value});
        }
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    protected OidStatement createDeclared(StmtContext<ObjectIdentifier, OidStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new OidIdStatementImpl((ObjectIdentifier)ctx.coerceStatementArgument(), substatements);
    }

    protected OidStatement createEmptyDeclared(StmtContext<ObjectIdentifier, OidStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    protected OidEffectiveStatement createEffective(StmtContext<ObjectIdentifier, OidStatement, OidEffectiveStatement> ctx, OidStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new OidEffectiveStatementImpl(declared, substatements, ctx);
    }

    protected OidEffectiveStatement createEmptyEffective(StmtContext<ObjectIdentifier, OidStatement, OidEffectiveStatement> ctx, OidStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }
}

