/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6643.parser;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc6643.model.api.IetfYangSmiv2ExtensionsMapping;
import org.opendaylight.yangtools.rfc6643.model.api.SubIdEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.SubIdStatement;
import org.opendaylight.yangtools.rfc6643.parser.SubIdEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc6643.parser.SubIdStatementImpl;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public final class SubIdStatementSupport
extends BaseStatementSupport<Uint32, SubIdStatement, SubIdEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)IetfYangSmiv2ExtensionsMapping.SUB_ID).build();
    private static final SubIdStatementSupport INSTANCE = new SubIdStatementSupport();

    private SubIdStatementSupport() {
        super((StatementDefinition)IetfYangSmiv2ExtensionsMapping.SUB_ID);
    }

    public static SubIdStatementSupport getInstance() {
        return INSTANCE;
    }

    public Uint32 parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return Uint32.valueOf((String)value);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    protected SubIdStatement createDeclared(StmtContext<Uint32, SubIdStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new SubIdStatementImpl((Uint32)ctx.coerceStatementArgument(), substatements);
    }

    protected SubIdStatement createEmptyDeclared(StmtContext<Uint32, SubIdStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    protected SubIdEffectiveStatement createEffective(StmtContext<Uint32, SubIdStatement, SubIdEffectiveStatement> ctx, SubIdStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new SubIdEffectiveStatementImpl(declared, substatements, ctx);
    }

    protected SubIdEffectiveStatement createEmptyEffective(StmtContext<Uint32, SubIdStatement, SubIdEffectiveStatement> ctx, SubIdStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }
}

