/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rcf8528.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.rcf8528.data.util.AbstractDynamicMountPointContextFactory;
import org.opendaylight.yangtools.rcf8528.data.util.EmptyMountPointContext;
import org.opendaylight.yangtools.rcf8528.data.util.ImmutableMountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContextFactory;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.rfc8528.model.api.SchemaMountConstants;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@NonNullByDefault
public abstract class AbstractMountPointContextFactory
extends AbstractDynamicMountPointContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMountPointContextFactory.class);
    private static final YangInstanceIdentifier.NodeIdentifier SCHEMA_MOUNTS = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"schema-mounts").intern());
    private static final YangInstanceIdentifier.NodeIdentifier MOUNT_POINT = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"mount-point").intern());
    private static final YangInstanceIdentifier.NodeIdentifier CONFIG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"config").intern());
    private static final YangInstanceIdentifier.NodeIdentifier MODULE = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"module").intern());
    private static final YangInstanceIdentifier.NodeIdentifier LABEL = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"label").intern());
    private static final YangInstanceIdentifier.NodeIdentifier SCHEMA_REF = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"schema-ref").intern());
    private static final YangInstanceIdentifier.NodeIdentifier INLINE = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"inline").intern());
    private static final YangInstanceIdentifier.NodeIdentifier SHARED_SCHEMA = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"shared-schema").intern());
    private static final YangInstanceIdentifier.NodeIdentifier PARENT_REFERENCE = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"parent-reference").intern());

    protected AbstractMountPointContextFactory(MountPointIdentifier mountId) {
        super(mountId);
    }

    @Override
    protected final MountPointContext createMountPointContext(EffectiveModelContext schemaContext, ContainerNode mountData) {
        Preconditions.checkArgument((boolean)SCHEMA_MOUNTS.equals((Object)mountData.getIdentifier()), (String)"Unexpected top-level container %s", (Object)mountData);
        Optional optMountPoint = mountData.getChild((YangInstanceIdentifier.PathArgument)MOUNT_POINT);
        if (optMountPoint.isEmpty()) {
            LOG.debug("mount-point list not present in {}", (Object)mountData);
            return new EmptyMountPointContext(schemaContext);
        }
        DataContainerChild mountPoint = (DataContainerChild)optMountPoint.get();
        Preconditions.checkArgument((boolean)(mountPoint instanceof MapNode), (String)"mount-point list %s is not a MapNode", (Object)mountPoint);
        return new ImmutableMountPointContext(schemaContext, ((MapNode)mountPoint).getValue().stream().map(entry -> {
            String moduleName = entry.getChild((YangInstanceIdentifier.PathArgument)MODULE).map(mod -> {
                Preconditions.checkArgument((boolean)(mod instanceof LeafNode), (String)"Unexpected module leaf %s", (Object)mod);
                Object value = mod.getValue();
                Preconditions.checkArgument((boolean)(value instanceof String), (String)"Unexpected module leaf value %s", (Object)value);
                return (String)value;
            }).orElseThrow(() -> new IllegalArgumentException("Mount module missing in " + entry));
            Iterator it = schemaContext.findModules(moduleName).iterator();
            Preconditions.checkArgument((boolean)it.hasNext(), (String)"Failed to find a module named %s", (Object)moduleName);
            QNameModule module = ((Module)it.next()).getQNameModule();
            return new MountPointDefinition(MountPointIdentifier.of((QName)QName.create((QNameModule)module, (String)entry.getChild((YangInstanceIdentifier.PathArgument)LABEL).map(lbl -> {
                Preconditions.checkArgument((boolean)(lbl instanceof LeafNode), (String)"Unexpected label leaf %s", (Object)lbl);
                Object value = lbl.getValue();
                Preconditions.checkArgument((boolean)(value instanceof String), (String)"Unexpected label leaf value %s", (Object)value);
                return (String)value;
            }).orElseThrow(() -> new IllegalArgumentException("Mount module missing in " + entry)))), entry.getChild((YangInstanceIdentifier.PathArgument)CONFIG).map(cfg -> {
                Preconditions.checkArgument((boolean)(cfg instanceof LeafNode), (String)"Unexpected config leaf %s", (Object)cfg);
                Object value = cfg.getValue();
                Preconditions.checkArgument((boolean)(value instanceof Boolean), (String)"Unexpected config leaf value %s", (Object)cfg);
                return (Boolean)value;
            }).orElse(Boolean.TRUE), AbstractMountPointContextFactory.getSchema((DataContainerChild)entry.getChild((YangInstanceIdentifier.PathArgument)SCHEMA_REF).orElseThrow(() -> new IllegalArgumentException("Missing schema-ref choice in " + entry))));
        }).collect(Collectors.toList()), this::createContextFactory);
    }

    private static ImmutableSet<String> getSchema(DataContainerChild<?, ?> child) {
        Preconditions.checkArgument((boolean)(child instanceof ChoiceNode), (String)"Unexpected schema-ref choice %s", child);
        ChoiceNode schemaRef = (ChoiceNode)child;
        return schemaRef.getChild((YangInstanceIdentifier.PathArgument)SHARED_SCHEMA).map(sharedSchema -> {
            Preconditions.checkArgument((boolean)(sharedSchema instanceof ContainerNode), (String)"Unexpected shared-schema container %s", (Object)sharedSchema);
            return ((ContainerNode)sharedSchema).getChild((YangInstanceIdentifier.PathArgument)PARENT_REFERENCE).map(parentRef -> ImmutableSet.of()).orElseGet(ImmutableSet::of);
        }).orElseGet(() -> {
            Preconditions.checkArgument((boolean)schemaRef.getChild((YangInstanceIdentifier.PathArgument)INLINE).isPresent(), (String)"Unhandled schema-ref type in %s", (Object)schemaRef);
            return ImmutableSet.of();
        });
    }

    protected abstract MountPointContextFactory createContextFactory(MountPointDefinition var1);

    protected static final class MountPointDefinition
    extends AbstractIdentifiable<MountPointIdentifier>
    implements Immutable {
        private final ImmutableSet<String> parentReferences;
        private final boolean config;

        MountPointDefinition(MountPointIdentifier identifier, boolean config, ImmutableSet<String> parentReferences) {
            super((Object)identifier);
            this.config = config;
            this.parentReferences = Objects.requireNonNull(parentReferences);
        }

        public boolean getConfig() {
            return this.config;
        }

        public ImmutableSet<String> getParentReferences() {
            return this.parentReferences;
        }

        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return super.addToStringAttributes(toStringHelper).add("config", this.config).add("parentReferences", this.parentReferences);
        }
    }
}

