/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rcf8528.data.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.rcf8528.data.util.AbstractMountPointContextFactory;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContextFactory;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.util.AbstractEffectiveModelContextProvider;

final class ImmutableMountPointContext
extends AbstractEffectiveModelContextProvider
implements Immutable,
MountPointContext {
    private final ImmutableMap<MountPointIdentifier, AbstractMountPointContextFactory.MountPointDefinition> mountPoints;
    private final Function<AbstractMountPointContextFactory.MountPointDefinition, MountPointContextFactory> createFactory;

    ImmutableMountPointContext(EffectiveModelContext modelContext, Iterable<AbstractMountPointContextFactory.MountPointDefinition> mountPoints, Function<AbstractMountPointContextFactory.MountPointDefinition, MountPointContextFactory> createFactory) {
        super(modelContext);
        this.mountPoints = Maps.uniqueIndex(mountPoints, AbstractIdentifiable::getIdentifier);
        this.createFactory = Objects.requireNonNull(createFactory);
    }

    public Optional<MountPointContextFactory> findMountPoint(MountPointIdentifier label) {
        AbstractMountPointContextFactory.MountPointDefinition def = (AbstractMountPointContextFactory.MountPointDefinition)((Object)this.mountPoints.get((Object)Objects.requireNonNull(label)));
        return def == null ? Optional.empty() : Optional.of(this.createFactory.apply(def));
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("mountPoints", this.mountPoints);
    }
}

