/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rcf8528.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;

@Beta
public final class ImmutableMountPointNode
extends AbstractIdentifiable<MountPointIdentifier>
implements MountPointNode,
Immutable {
    private final @NonNull MountPointContext mountCtx;
    private final @NonNull ContainerNode delegate;

    ImmutableMountPointNode(@NonNull MountPointIdentifier identifier, @NonNull MountPointContext mountCtx, @NonNull ContainerNode delegate) {
        super((Object)identifier);
        this.mountCtx = Objects.requireNonNull(mountCtx);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public static @NonNull ImmutableMountPointNode of(@NonNull MountPointIdentifier identifier, @NonNull MountPointContext mountCtx, @NonNull ContainerNode delegate) {
        return new ImmutableMountPointNode(identifier, mountCtx, delegate);
    }

    public MountPointContext getMountPointContext() {
        return this.mountCtx;
    }

    public Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getValue() {
        return this.delegate.getValue();
    }

    public Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getChild(YangInstanceIdentifier.PathArgument child) {
        return this.delegate.getChild(child);
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("delegate", (Object)this.delegate);
    }
}

