/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Verify;
import com.google.common.collect.RangeSet;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.data.api.codec.YangInvalidValueException;
import org.opendaylight.yangtools.yang.data.impl.codec.Int16StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Int32StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Int64StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Int8StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Uint16StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Uint32StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Uint64StringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.Uint8StringCodec;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;

@Beta
public abstract class AbstractIntegerStringCodec<N extends Number, T extends RangeRestrictedTypeDefinition<T, N>>
extends TypeDefinitionAwareCodec<N, T> {
    private static final Pattern INT_PATTERN = Pattern.compile("[+-]?[1-9][0-9]*$");
    private static final Pattern HEX_PATTERN = Pattern.compile("[+-]?0[xX][0-9a-fA-F]+");
    private static final Pattern OCT_PATTERN = Pattern.compile("[+-]?0[1-7][0-7]*$");
    private static final CharMatcher X_MATCHER = CharMatcher.anyOf((CharSequence)"xX");
    private final RangeConstraint<N> rangeConstraint;

    AbstractIntegerStringCodec(T typeDefinition, Optional<RangeConstraint<N>> constraint, Class<N> outputClass) {
        super((RangeRestrictedTypeDefinition)Objects.requireNonNull(typeDefinition), outputClass);
        this.rangeConstraint = constraint.orElse(null);
    }

    public static @NonNull AbstractIntegerStringCodec<Byte, Int8TypeDefinition> from(Int8TypeDefinition type) {
        return new Int8StringCodec(type);
    }

    public static @NonNull AbstractIntegerStringCodec<Short, Int16TypeDefinition> from(Int16TypeDefinition type) {
        return new Int16StringCodec(type);
    }

    public static @NonNull AbstractIntegerStringCodec<Integer, Int32TypeDefinition> from(Int32TypeDefinition type) {
        return new Int32StringCodec(type);
    }

    public static @NonNull AbstractIntegerStringCodec<Long, Int64TypeDefinition> from(Int64TypeDefinition type) {
        return new Int64StringCodec(type);
    }

    public static @NonNull AbstractIntegerStringCodec<Uint8, Uint8TypeDefinition> from(Uint8TypeDefinition type) {
        return new Uint8StringCodec(type);
    }

    public static @NonNull AbstractIntegerStringCodec<Uint16, Uint16TypeDefinition> from(Uint16TypeDefinition type) {
        return new Uint16StringCodec(type);
    }

    public static @NonNull AbstractIntegerStringCodec<Uint32, Uint32TypeDefinition> from(Uint32TypeDefinition type) {
        return new Uint32StringCodec(type);
    }

    public static @NonNull AbstractIntegerStringCodec<Uint64, Uint64TypeDefinition> from(Uint64TypeDefinition type) {
        return new Uint64StringCodec(type);
    }

    protected final N deserializeImpl(String product) {
        RangeSet ranges;
        int base = AbstractIntegerStringCodec.provideBase(product);
        String stringRepresentation = base != 16 ? product : X_MATCHER.removeFrom((CharSequence)product);
        Number deserialized = (Number)Verify.verifyNotNull(this.deserialize(stringRepresentation, base));
        if (this.rangeConstraint != null && !(ranges = this.rangeConstraint.getAllowedRanges()).contains((Comparable)((Object)deserialized))) {
            throw new YangInvalidValueException(RpcError.ErrorType.APPLICATION, this.rangeConstraint, "Value '" + deserialized + "'  is not in required ranges " + ranges);
        }
        return (N)deserialized;
    }

    protected final String serializeImpl(N input) {
        return input.toString();
    }

    protected abstract @NonNull N deserialize(@NonNull String var1, int var2);

    protected static <N extends Number> Optional<RangeConstraint<N>> extractRange(RangeRestrictedTypeDefinition<?, N> type) {
        return type == null ? Optional.empty() : type.getRangeConstraint();
    }

    private static int provideBase(String integer) {
        if (integer.length() == 1 && integer.charAt(0) == '0' || INT_PATTERN.matcher(integer).matches()) {
            return 10;
        }
        if (HEX_PATTERN.matcher(integer).matches()) {
            return 16;
        }
        if (OCT_PATTERN.matcher(integer).matches()) {
            return 8;
        }
        throw new NumberFormatException("Incorrect lexical representation of integer value: " + integer + ".\nAn integer value can be defined as:\n  - a decimal number,\n  - a hexadecimal number (prefix 0x),%n  - an octal number (prefix 0).\nSigned values are allowed. Spaces between digits are NOT allowed.");
    }
}

