/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.codec.YangInvalidValueException;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.type.ModifierKind;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;

final class CompiledPatternContext {
    private final PatternConstraint constraint;
    private final Pattern pattern;
    private final boolean invert;

    CompiledPatternContext(PatternConstraint yangConstraint) {
        this.constraint = Objects.requireNonNull(yangConstraint);
        this.pattern = Pattern.compile(yangConstraint.getJavaPatternString());
        Optional optModifier = yangConstraint.getModifier();
        if (optModifier.isPresent()) {
            ModifierKind modifier = (ModifierKind)optModifier.get();
            switch (modifier) {
                case INVERT_MATCH: {
                    this.invert = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled modifier " + modifier);
                }
            }
        } else {
            this.invert = false;
        }
    }

    void validate(String str) {
        if (this.pattern.matcher(str).matches() == this.invert) {
            throw new YangInvalidValueException(RpcError.ErrorType.APPLICATION, (ConstraintMetaDefinition)this.constraint, "Value '" + str + "' " + (this.invert ? "matches" : "does not match") + " regular expression '" + this.constraint.getRegularExpressionString() + "'");
        }
    }
}

