/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import java.math.BigDecimal;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.codec.DecimalCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;

@Beta
public final class DecimalStringCodec
extends TypeDefinitionAwareCodec<BigDecimal, DecimalTypeDefinition>
implements DecimalCodec<String> {
    private DecimalStringCodec(DecimalTypeDefinition typeDef) {
        super(typeDef, BigDecimal.class);
    }

    public static @NonNull DecimalStringCodec from(DecimalTypeDefinition type) {
        return new DecimalStringCodec(Objects.requireNonNull(type));
    }

    protected BigDecimal deserializeImpl(String product) {
        return new BigDecimal(product);
    }

    protected @NonNull String serializeImpl(@NonNull BigDecimal input) {
        return input.toString();
    }
}

