/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Base64;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.api.codec.UnionCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UnionStringCodec
extends TypeDefinitionAwareCodec<Object, UnionTypeDefinition>
implements UnionCodec<String> {
    private static final Logger LOG = LoggerFactory.getLogger(UnionStringCodec.class);

    UnionStringCodec(UnionTypeDefinition typeDef) {
        super(Objects.requireNonNull(typeDef), Object.class);
    }

    static TypeDefinitionAwareCodec<?, UnionTypeDefinition> from(UnionTypeDefinition normalizedType) {
        return new UnionStringCodec(normalizedType);
    }

    protected Object deserializeImpl(String stringRepresentation) {
        for (TypeDefinition type : ((UnionTypeDefinition)this.getTypeDefinition().get()).getTypes()) {
            TypeDefinitionAwareCodec<Object, ?> typeAwareCodec = UnionStringCodec.from(type);
            if (typeAwareCodec == null) {
                return stringRepresentation;
            }
            try {
                return typeAwareCodec.deserialize(stringRepresentation);
            }
            catch (Exception e) {
                LOG.debug("Value {} did not matched representation for {}", new Object[]{stringRepresentation, type, e});
            }
        }
        throw new IllegalArgumentException("Invalid value \"" + stringRepresentation + "\" for union type.");
    }

    protected String serializeImpl(Object data) {
        return data instanceof byte[] ? Base64.getEncoder().encodeToString((byte[])data) : data.toString();
    }
}

