/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedValueNode;

public class ImmutableUnkeyedListNodeBuilder
implements CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> {
    private List<UnkeyedListEntryNode> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    protected ImmutableUnkeyedListNodeBuilder() {
        this.value = new LinkedList<UnkeyedListEntryNode>();
        this.dirty = false;
    }

    protected ImmutableUnkeyedListNodeBuilder(ImmutableUnkeyedListNode node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.getIdentifier();
        this.value = new LinkedList<UnkeyedListEntryNode>();
        Iterables.addAll(this.value, (Iterable)((Iterable)node.getValue()));
        this.dirty = true;
    }

    public static @NonNull CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> create() {
        return new ImmutableUnkeyedListNodeBuilder();
    }

    public static @NonNull CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> create(int sizeHint) {
        return new ImmutableUnkeyedListNodeBuilder();
    }

    public static @NonNull CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> create(UnkeyedListNode node) {
        if (!(node instanceof ImmutableUnkeyedListNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableUnkeyedListNodeBuilder((ImmutableUnkeyedListNode)node);
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedList<UnkeyedListEntryNode>(this.value);
            this.dirty = false;
        }
    }

    @Override
    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> withChild(UnkeyedListEntryNode child) {
        this.checkDirty();
        this.value.add(child);
        return this;
    }

    @Override
    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        throw new UnsupportedOperationException("Children does not have identifiers.");
    }

    @Override
    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> withValue(Collection<UnkeyedListEntryNode> withValue) {
        for (UnkeyedListEntryNode node : withValue) {
            this.withChild(node);
        }
        return this;
    }

    @Override
    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    @Override
    public UnkeyedListNode build() {
        this.dirty = true;
        if (this.value.isEmpty()) {
            return new EmptyImmutableUnkeyedListNode(this.nodeIdentifier);
        }
        return new ImmutableUnkeyedListNode(this.nodeIdentifier, (ImmutableList<UnkeyedListEntryNode>)ImmutableList.copyOf(this.value));
    }

    public CollectionNodeBuilder<UnkeyedListEntryNode, UnkeyedListNode> addChild(UnkeyedListEntryNode child) {
        return this.withChild(child);
    }

    @Override
    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, UnkeyedListEntryNode, UnkeyedListNode> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableUnkeyedListNode
    extends AbstractImmutableNormalizedValueNode<YangInstanceIdentifier.NodeIdentifier, Collection<UnkeyedListEntryNode>>
    implements UnkeyedListNode {
        private final ImmutableList<UnkeyedListEntryNode> children;

        ImmutableUnkeyedListNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, ImmutableList<UnkeyedListEntryNode> children) {
            super(nodeIdentifier, children);
            this.children = children;
        }

        @Override
        protected int valueHashCode() {
            return this.children.hashCode();
        }

        @Override
        protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
            return this.children.equals(((ImmutableUnkeyedListNode)other).children);
        }

        public UnkeyedListEntryNode getChild(int position) {
            return (UnkeyedListEntryNode)this.children.get(position);
        }

        public int getSize() {
            return this.children.size();
        }
    }

    protected static final class EmptyImmutableUnkeyedListNode
    extends AbstractImmutableNormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<UnkeyedListEntryNode>>
    implements UnkeyedListNode {
        protected EmptyImmutableUnkeyedListNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier) {
            super(nodeIdentifier);
        }

        public ImmutableList<UnkeyedListEntryNode> getValue() {
            return ImmutableList.of();
        }

        public UnkeyedListEntryNode getChild(int position) {
            throw new IndexOutOfBoundsException();
        }

        public int getSize() {
            return 0;
        }

        @Override
        protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
            return Collections.emptyList().equals(other.getValue());
        }

        @Override
        protected int valueHashCode() {
            return 1;
        }
    }
}

