/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

public class DataValidationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public DataValidationException(String message) {
        super(message);
    }

    public static void checkLegalChild(boolean isLegal, YangInstanceIdentifier.PathArgument child, DataNodeContainer schema, Set<QName> childNodes, Set<YangInstanceIdentifier.AugmentationIdentifier> augments) {
        if (!isLegal) {
            throw new IllegalChildException(child, schema, childNodes, augments);
        }
    }

    public static void checkLegalChild(boolean isLegal, YangInstanceIdentifier.PathArgument child, DataSchemaNode schema, Set<QName> childNodes) {
        if (!isLegal) {
            throw new IllegalChildException(child, schema, childNodes);
        }
    }

    public static void checkLegalChild(boolean isLegal, YangInstanceIdentifier.PathArgument child, ChoiceSchemaNode schema) {
        if (!isLegal) {
            throw new IllegalChildException(child, schema);
        }
    }

    public static void checkLegalData(boolean isLegal, String messageTemplate, Object ... messageAttrs) {
        if (!isLegal) {
            throw new DataValidationException(String.format(messageTemplate, messageAttrs));
        }
    }

    public static void checkListKey(YangInstanceIdentifier.NodeIdentifierWithPredicates nodeId, QName keyQName, Object expected, Object actual) {
        if (!Objects.equals(expected, actual) && !Objects.deepEquals(expected, actual)) {
            throw new IllegalListKeyException(keyQName, nodeId, actual, expected);
        }
    }

    public static void checkListKey(DataContainerChild<?, ?> childNode, Map<QName, Object> keyValues, QName keyQName, YangInstanceIdentifier.NodeIdentifierWithPredicates nodeId) {
        DataValidationException.checkListKey(childNode, keyQName, nodeId);
        Object expected = keyValues.get(keyQName);
        Object actual = childNode.getValue();
        DataValidationException.checkListKey(nodeId, keyQName, expected, actual);
    }

    public static void checkListKey(DataContainerChild<?, ?> childNode, QName keyQName, YangInstanceIdentifier.NodeIdentifierWithPredicates nodeId) {
        if (childNode == null) {
            throw new IllegalListKeyException(keyQName, nodeId);
        }
    }

    @Beta
    public static final class IllegalListKeyException
    extends DataValidationException {
        private static final long serialVersionUID = 1L;

        public IllegalListKeyException(String format, Object ... args) {
            super(String.format(format, args));
        }

        IllegalListKeyException(QName keyQName, YangInstanceIdentifier.NodeIdentifierWithPredicates id) {
            this("Key value not present for key: %s, in: %s", keyQName, id);
        }

        IllegalListKeyException(QName keyQName, YangInstanceIdentifier.NodeIdentifierWithPredicates id, Object actualValue, Object expectedValue) {
            this("Illegal value for key: %s, in: %s, actual value: %s, expected value from key: %s", keyQName, id, actualValue, expectedValue);
        }
    }

    private static final class IllegalChildException
    extends DataValidationException {
        private static final long serialVersionUID = 1L;

        IllegalChildException(YangInstanceIdentifier.PathArgument child, DataNodeContainer schema, Set<QName> childNodes, Set<YangInstanceIdentifier.AugmentationIdentifier> augments) {
            super(String.format("Unknown child node: %s, does not belong to: %s as a direct child. Direct child nodes: %s, augmented child nodes: %s", child, schema, childNodes, augments));
        }

        IllegalChildException(YangInstanceIdentifier.PathArgument child, ChoiceSchemaNode schema) {
            super(String.format("Unknown child node: %s, not detected in choice: %s", child, schema));
        }

        IllegalChildException(YangInstanceIdentifier.PathArgument child, DataSchemaNode schema, Set<QName> childNodes) {
            super(String.format("Unknown child node: %s, does not belong to: %s as a child. Child nodes: %s", child, schema, childNodes));
        }
    }
}

