/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.LazyLeafOperations;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.LazyValues;

public abstract class AbstractImmutableDataContainerNode<K extends YangInstanceIdentifier.PathArgument>
extends AbstractImmutableNormalizedNode<K, Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>>>
implements DataContainerNode<K> {
    private final Map<YangInstanceIdentifier.PathArgument, Object> children;

    protected AbstractImmutableDataContainerNode(Map<YangInstanceIdentifier.PathArgument, Object> children, K nodeIdentifier) {
        super(nodeIdentifier);
        this.children = ImmutableOffsetMap.unorderedCopyOf(children);
    }

    public final Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getChild(YangInstanceIdentifier.PathArgument child) {
        return Optional.ofNullable(LazyLeafOperations.getChild(this.children, child));
    }

    public final Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getValue() {
        return new LazyValues(this.children);
    }

    public final int size() {
        return this.children.size();
    }

    @Override
    protected int valueHashCode() {
        return this.children.hashCode();
    }

    public final Map<YangInstanceIdentifier.PathArgument, Object> getChildren() {
        return this.children;
    }

    @Override
    protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
        return other instanceof AbstractImmutableDataContainerNode && this.children.equals(((AbstractImmutableDataContainerNode)other).children);
    }
}

