/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.LazyLeafOperations;

final class LazyValues
extends AbstractCollection<DataContainerChild<?, ?>> {
    private final Map<YangInstanceIdentifier.PathArgument, Object> map;

    LazyValues(Map<YangInstanceIdentifier.PathArgument, Object> map) {
        this.map = Objects.requireNonNull(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<DataContainerChild<?, ?>> iterator() {
        return new Iter(this.map.entrySet().iterator());
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof LazyValues && this.map.equals(((LazyValues)obj).map);
    }

    private static final class Iter
    implements Iterator<DataContainerChild<?, ?>> {
        private final Iterator<Map.Entry<YangInstanceIdentifier.PathArgument, Object>> iterator;

        Iter(Iterator<Map.Entry<YangInstanceIdentifier.PathArgument, Object>> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DataContainerChild<?, ?> next() {
            Map.Entry<YangInstanceIdentifier.PathArgument, Object> entry = this.iterator.next();
            Object value = entry.getValue();
            return value instanceof DataContainerChild ? (LeafNode<?>)value : LazyLeafOperations.coerceLeaf(entry.getKey(), value);
        }
    }
}

