/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;

abstract class AbstractReadyIterator {
    final Iterator<ModifiedNode> children;
    final ModifiedNode node;
    final ModificationApplyOperation op;

    private AbstractReadyIterator(ModifiedNode node, Iterator<ModifiedNode> children, ModificationApplyOperation operation) {
        this.children = Objects.requireNonNull(children);
        this.node = Objects.requireNonNull(node);
        this.op = Objects.requireNonNull(operation);
    }

    static AbstractReadyIterator create(ModifiedNode root, ModificationApplyOperation operation) {
        return new RootReadyIterator(root, root.getChildren().iterator(), operation);
    }

    final AbstractReadyIterator process(Version version) {
        while (this.children.hasNext()) {
            ModifiedNode child = this.children.next();
            Optional<ModificationApplyOperation> childOperation = this.op.getChild(child.getIdentifier());
            Preconditions.checkState((boolean)childOperation.isPresent(), (String)"Schema for child %s is not present.", (Object)child.getIdentifier());
            Collection<ModifiedNode> grandChildren = child.getChildren();
            ModificationApplyOperation childOp = childOperation.get();
            if (grandChildren.isEmpty()) {
                child.seal(childOp, version);
                if (child.getOperation() != LogicalOperation.NONE) continue;
                this.children.remove();
                continue;
            }
            return new NestedReadyIterator(this, child, grandChildren.iterator(), childOp);
        }
        this.node.seal(this.op, version);
        if (this.node.getOperation() == LogicalOperation.NONE) {
            this.removeFromParent();
        }
        return this.getParent();
    }

    abstract AbstractReadyIterator getParent();

    abstract void removeFromParent();

    private static final class RootReadyIterator
    extends AbstractReadyIterator {
        private RootReadyIterator(ModifiedNode node, Iterator<ModifiedNode> children, ModificationApplyOperation operation) {
            super(node, children, operation);
        }

        @Override
        AbstractReadyIterator getParent() {
            return null;
        }

        @Override
        void removeFromParent() {
        }
    }

    private static final class NestedReadyIterator
    extends AbstractReadyIterator {
        private final AbstractReadyIterator parent;

        private NestedReadyIterator(AbstractReadyIterator parent, ModifiedNode node, Iterator<ModifiedNode> children, ModificationApplyOperation operation) {
            super(node, children, operation);
            this.parent = Objects.requireNonNull(parent);
        }

        @Override
        AbstractReadyIterator getParent() {
            return this.parent;
        }

        @Override
        void removeFromParent() {
            this.parent.children.remove();
        }
    }
}

